% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_eval.R
\name{efs_eval}
\alias{efs_eval}
\title{Evaluation of Ensemble Features Selection}
\usage{
efs_eval(data, efs_table, file_name, classnumber, NA_threshold, logreg = TRUE,
  permutation = TRUE, p_num, variances = TRUE, jaccard = TRUE, bs_num,
  bs_percentage)
}
\arguments{
\item{data}{object of class data.frame}

\item{efs_table}{table object of class matrix (retrieved
from \code{ensemble_fs})}

\item{file_name}{character string, name which is used for the two 
possible PDF files.}

\item{classnumber}{numeric, index of variable for binary classification}

\item{NA_threshold}{(optional) decimal number in range of [0,1]. Threshold for deletion
of features with a greater proportion of NAs than \code{NA_threshold}.}

\item{logreg}{logical value indicating whether to conduct an evaluation 
via logistic regression or not}

\item{permutation}{logical value indicating whether to conduct a permutation 
of the class variable or not}

\item{p_num}{number of permutations; default set to a 100}

\item{variances}{logical value indicating whether to calculate the variances 
of importances retrieved from bootrapping or not}

\item{jaccard}{logical value indicating whether to calculate the jaccard-index or not}

\item{bs_num}{number of boostrap permutations of the importances}

\item{bs_percentage}{proportion of randomly selected samples for boostraping}
}
\value{
An object of class list, with the following components: 
\cr "AUC of logistic regression", 
\cr "P-value of ROC test",
\cr "P-value of permutation", 
\cr "Variances of feature importances",
\cr "Jaccard-index".
}
\description{
Provides several evaluation tests of
 the ouput of \code{\link{ensemble_fs}}. There are
 performance test, namely the logreg test and permutation 
 test as well as tests of stability via the variance 
 of feature importances (see Note).
}
\details{
A logistic regression model with leave-one-out cross-validation (LOOCV) of the
 selected features and of all feature is conducted by \code{logreg =TRUE}.
 Both AUC-values of the ROC curves are compared with \code{\link{roc.test}}.
 The ROC curves are illustrated on the PDF file "file_name" + "-ROC.pdf".
 \cr 
 \cr The permutation test (\code{permutation = TRUE}) compares the AUC outcome of 
 an logistic regression with \code{p_num} AUCs from random 
 permutations of the class variable by a \code{\link{t.test}}.
 \cr 
 \cr Variances of the importances after a bootstrapping analysis are 
 calculated by \code{variances = TRUE}. Thereby the number and proportion
 of the bootstrapping can be set by \code{bs_num} and \code{bs_percentage}.
 The function also provides a PDF file "file_name" +"_Variances.pdf".
 Additionally, the Jaccard-index of this bootstrapped importances 
 can be calculated by setting \code{jaccard=TRUE}.
}
\examples{
 ##loading dataset in Environment
 data(efsdata)
 ## Generate a ranking based on importance (with default
 ## NA_threshold = 0.7,cor_threshold = 0.2)
 efs<-ensemble_fs(efsdata,5,runs=2)
 ## Conduct AUC test and permutation test
 eval_example <- efs_eval(data = efsdata, efs_table = efs, file_name = 'eval_test', 
                      classnumber = 5, NA_threshold = 0.2,
                      logreg = TRUE,
                      permutation = TRUE, p_num = 2, 
                      variances = FALSE, jaccard = FALSE)
## Calculating variances and the Jaccard-index can take several minutes computation time 
}
\author{
Ursula Neumann
}
\seealso{
\link[stats]{glm}, \link[pROC]{roc}
}

