% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.EGA.R
\name{plot.EGA}
\alias{plot.EGA}
\title{Plot method for EGA objects.}
\usage{
\method{plot}{EGA}(x, title = "", vsize = 6, ...)
}
\arguments{
\item{x}{An \code{\link{EGA}} object}

\item{title}{Character. Title of the plot}

\item{vsize}{An integer indicating the size of the nodes.
Default vsize = 6}

\item{...}{Arguments passed to \code{\link[qgraph]{qgraph}}}
}
\description{
Plots the EGA result using \code{\link{qgraph}}
}
\examples{
\donttest{
#estimate EGA
ega.wmt <- EGA(data = wmt2[,7:24], plot.EGA = TRUE)

#summary of EGA results
summary(ega.wmt)

#plot EGA network
plot(ega.wmt, vsize = 6)
}
}
\seealso{
\code{\link{EGA}} to estimate the number of dimensions of an instrument using EGA
and \code{\link{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
