% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsd.R
\name{jsd}
\alias{jsd}
\title{Jensen-Shannon Distance}
\usage{
jsd(network1, network2, method = c("kld", "spectral"))
}
\arguments{
\item{network1}{Matrix or data frame.
Network to be compared}

\item{network2}{Matrix or data frame.
Second network to be compared}

\item{method}{Character.
Method to compute Jensen-Shannon Distance.
Defaults to \code{"spectral"}.
Options:

\itemize{

\item{\code{"kld"}}
{Uses Kullback-Leibler Divergence}

\item{\code{"spectral"}}
{Uses eigenvalues of combinatiorial Laplacian matrix to compute
Von Neumann entropy}

}}
}
\value{
Returns Jensen-Shannon Distance
}
\description{
Computes the Jensen-Shannon Distance between two networks
}
\examples{
# Obtain wmt2 data
wmt <- wmt2[,7:24]

# Set seed (for reproducibility)
set.seed(1234)

# Split data
split1 <- sample(
  1:nrow(wmt), floor(nrow(wmt) / 2)
)
split2 <- setdiff(1:nrow(wmt), split1)

# Obtain split data
data1 <- wmt[split1,]
data2 <- wmt[split2,]

# Perform EBICglasso
glas1 <- EBICglasso.qgraph(data1)
glas2 <- EBICglasso.qgraph(data2)

# Spectral JSD 
jsd(glas1, glas2) # 0.1618195

# Spectral JSS (similarity)
1 - jsd(glas1, glas2) # 0.8381805

# Jensen-Shannon Divergence
jsd(glas1, glas2, method = "kld") # 0.1923636

}
\author{
Hudson Golino <hfg9s at virginia.edu> & Alexander P. Christensen <alexander.christensen at Vanderbilt.Edu>
}
