% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readUserDaily.r
\name{readUserDaily}
\alias{readUserDaily}
\title{Import user daily data for EGRET analysis}
\usage{
readUserDaily(filePath, fileName, hasHeader = TRUE, separator = ",",
  qUnit = 1, interactive = TRUE)
}
\arguments{
\item{filePath}{character specifying the path to the file}

\item{fileName}{character name of file to open}

\item{hasHeader}{logical true if the first row of data is the column headers}

\item{separator}{character character that separates data cells}

\item{qUnit}{number 1 is cubic feet per second, 2 is cubic meters per second, 3 is 10^3 cubic feet per second, and 4 is 10^3 cubic meters per second}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
A data frame 'Daily' with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
Date \tab Date \tab Date \cr
Q \tab numeric \tab Discharge in m^3/s\cr
Julian \tab integer \tab Number of days since Jan. 1, 1850\cr
Month \tab integer \tab Month of the year [1-12] \cr 
Day \tab integer \tab Day of the year [1-366] \cr
DecYear \tab numeric \tab Decimal year \cr
MonthSeq \tab integer \tab Number of months since January 1, 1850 \cr
Qualifier \tab character \tab Qualifying code \cr
i \tab integer \tab Index of days, starting with 1 \cr
LogQ \tab numeric \tab Natural logarithm of Q  \cr
Q7 \tab numeric \tab 7 day running average of Q \cr
Q30 \tab numeric \tab 30 day running average of Q \cr
}
}
\description{
Imports data from a user-supplied file, and converts it to a Daily data frame, appropriate for WRTDS calculations.
}
\examples{
filePath <- system.file("extdata", package="EGRET")
fileName <- "ChoptankRiverFlow.txt"
Daily <- readUserDaily(filePath,fileName,separator="\\t")
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{file}
\keyword{import}

