% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluxBiasStat.R
\name{fluxBiasStat}
\alias{fluxBiasStat}
\title{Compute the flux bias statistic: (mean of estimated flux - mean of observed flux)  / mean of observed flux}
\usage{
fluxBiasStat(localSample)
}
\arguments{
\item{localSample}{data frame that contains the concentration data, default name is Sample}
}
\value{
fluxBias a vector of three numerical values, a lower bound, upper bound and an average estimate of the ratio of (mean estimated flux - mean observed flux) / mean estimated flux.  Typically one should use fluxBias[3]
}
\description{
Computes three versions of the flux bias: 
  The first where all censored values are set to their miniumum. 
  The second where all censored values are set to their maximum. 
  The third which is the average of the other two. 
     In practice there is rarely a noticable difference among them.
}
\examples{
eList <- Choptank_eList
Sample <- getSample(eList)
fluxBias <- fluxBiasStat(Sample) 
}
\keyword{bias}
\keyword{statistics,}
\keyword{water-quality}
