\name{define.limits}
\alias{define.limits}
\title{Function to define limits by mouse clicks.}
\description{This function allows to define limits for robust end-members by mouse
clicks on a combined plot output, showing a histogram and all end-members 
together. Clicks must be placed in the order lower limit, upper limit - for 
each end-member successively.}
\usage{define.limits(data, n, classunits)}
\arguments{
  \item{data}{Output of \code{\link{test.robustness}}, a list with several objects.}
  \item{n}{Numeric scalar with number of target end-members (i.e. half the number of 
limits).}
  \item{classunits}{Numeric vector, optional class units (e.g. micrometers or phi-units).}
}

\value{Numeric matrix with limit classes. The first row contains lower
limits, the second row upper limits for each end-member.}

\author{Michael Dietze, Elisabeth Dietze}



\seealso{\code{\link{test.robustness}}, \code{\link{robust.EM}}}
\examples{
## load example data set
data(X.artificial, envir = environment())

## Test robustness
q <- 4:7
lw <- seq(from = 0, to = 0.1, by = 0.02)
TR <- test.robustness(X = X.artificial, q = q, lw = lw)

## define 2 limits by mouse clicks (uncomment to use).
# limits <- define.limits(data = TR, n = 2)
# limits  
}

\keyword{EMMA}
