% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust.loadings.R
\name{robust.loadings}
\alias{robust.loadings}
\title{Extract robust end-member loadings}
\usage{
robust.loadings(
  em,
  limits,
  classunits,
  amount,
  type = "mean",
  qt = c(0.25, 0.75),
  plot = FALSE,
  ...
)
}
\arguments{
\item{em}{\code{List} of class \code{"EMMAgeo_empot"}, i.e. the outout of 
\code{model.EM()} or \code{test.robustness()}, containing potential 
end-members, both in unscaled and rescaled version as well as further 
parameters.}

\item{limits}{\code{Numeric} matrix with two columns, defining the class limits 
for the robust end-members to calculate. The first column defines the lower
limits, the second column the upper limits. End-members are organised in 
rows.}

\item{classunits}{\code{Numeric} vector, optional class units 
(e.g. micrometers or phi-units) of the same length as the number of 
(grain-size) classes per sample.}

\item{amount}{\code{Numeric} matrix with two columns, defining the minimum and 
maximum amount of the modal class for each end-member.}

\item{type}{\code{Character} scalar, type of statistics. One out of 
\code{"mean"} and \code{"median"}. Default is \code{"mean"}.}

\item{qt}{\code{Numeric} vector of length two, quantiles to describe 
end-member loadings Default is \code{c(0.25, 0.75)} (i.e., 
the quartile range).}

\item{plot}{\code{Logical} scalar, option to enable plot output. Default 
is \code{FALSE}.}

\item{\dots}{Additional arguments passed to \code{EMMA} and \code{plot}.}
}
\value{
\code{List} with statistic descriptions of unscaled and scaled 
end-member loadings.
}
\description{
This function takes a list object with potential end-member loadings and 
extracts those with modes in specified limits to describe them by mean and
standard deviation.
}
\examples{

## load example data set, potential end-members, output of model.EM()
data(example_EMpot)

## define limits for robust end-members
limits <- cbind(c(61, 74, 95, 102), 
                c(64, 76, 100, 105))

## get robust end-member loadings with plot output
robust_loadings <- robust.loadings(em = EMpot,
                                   limits = limits,
                                   plot = TRUE)
                    
}
\seealso{
\code{\link{robust.EM}}, \code{\link{robust.scores}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
