% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interquartile.quartile.plot.R
\name{interquartile.quartile.plot}
\alias{interquartile.quartile.plot}
\title{plot interquartile effect of specific exposure based on quartile of other exposures}
\usage{
interquartile.quartile.plot(fit, data)
}
\arguments{
\item{fit}{Fitted model from function 'plsi.lr.v1'}

\item{data}{Original data set}
}
\value{
plot of main interquartile effect of exposure based on quartile of other exposures
}
\description{
plot interquartile effect of specific exposure based on quartile of other exposures
}
\examples{
\donttest{
# example to interquartile effect based on quartile of other exposures
data(nhanes.new)
dat <- nhanes.new

# specify variable names and parameters
Y.name <- "log.triglyceride"
X.name <- c("X1_trans.b.carotene", "X2_retinol", "X3_g.tocopherol", "X4_a.tocopherol",
            "X5_PCB99", "X6_PCB156", "X7_PCB206",
            "X8_3.3.4.4.5.pncb", "X9_1.2.3.4.7.8.hxcdf", "X10_2.3.4.6.7.8.hxcdf")
Z.name <- c("AGE.c", "SEX.Female", "RACE.NH.Black",
           "RACE.MexicanAmerican", "RACE.OtherRace", "RACE.Hispanic" )
spline.num = 5
spline.degree = 3
initial.random.num = 1

# run PLSI linear regression
set.seed(2023)
model_1 <- plsi.lr.v1(data = dat, Y.name = Y.name, X.name = X.name, Z.name = Z.name,
                      spline.num, spline.degree, initial.random.num)

# plot interquartile quartile
interquartile.quartile.plot(model_1, dat)
}
}
\author{
Yuyan Wang
}
\keyword{interquartile.quartile.effect}
