% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_network_structures.R
\name{Separated_GPD_SNN}
\alias{Separated_GPD_SNN}
\title{Self-normalized separated network module for GPD parameter prediction}
\usage{
Separated_GPD_SNN(
  D_in,
  Hidden_vect_scale = c(64, 64, 64),
  Hidden_vect_shape = c(5, 3),
  p_drop = 0.01
)
}
\arguments{
\item{D_in}{the input size (i.e. the number of features),}

\item{Hidden_vect_scale}{a vector of integers whose length determines the number of layers in the sub-network
for the scale parameter and entries the number of neurons in each corresponding successive layer,}

\item{Hidden_vect_shape}{a vector of integers whose length determines the number of layers in the sub-network
for the shape parameter and entries the number of neurons in each corresponding successive layer,}

\item{p_drop}{probability parameter for the \code{alpha-dropout} before each hidden layer for regularization during training.}
}
\value{
The specified parameter-separated SNN MLP GPD network as a \code{\link[torch:nn_module]{torch::nn_module}}.
}
\description{
A parameter-separated self-normalizing network as a \code{\link[torch:nn_module]{torch::nn_module}},
designed for generalized Pareto distribution parameter prediction.
}
\details{
The constructor allows specifying:
\describe{
\item{D_in}{the input size (i.e. the number of features),}
\item{Hidden_vect_scale}{a vector of integers whose length determines the number of layers in the sub-network
for the scale parameter and entries the number of neurons in each corresponding successive layer,}
\item{Hidden_vect_shape}{a vector of integers whose length determines the number of layers in the sub-network
for the shape parameter and entries the number of neurons in each corresponding successive layer,}
\item{p_drop}{probability parameter for the \code{alpha-dropout} before each hidden layer for regularization during training.}
}
}
\references{
Gunter Klambauer, Thomas Unterthiner, Andreas Mayr, Sepp Hochreiter. Self-Normalizing Neural Networks.
Advances in Neural Information Processing Systems 30 (NIPS 2017), 2017.
}
