% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{process_features}
\alias{process_features}
\title{Feature processor for EQRN}
\usage{
process_features(
  X,
  intermediate_q_feature,
  intermediate_quantiles = NULL,
  X_scaling = NULL,
  scale_features = TRUE
)
}
\arguments{
\item{X}{A covariate matrix.}

\item{intermediate_q_feature}{Whether to use the intermediate \code{quantiles} as an additional covariate,
by appending it to the \code{X} matrix (bool).}

\item{intermediate_quantiles}{The intermediate conditional quantiles.}

\item{X_scaling}{Existing \code{"X_scaling"} object containing the precomputed mean and variance for each covariate.
This enables reusing the scaling choice and parameters from the train set, if computing the excesses on a validation or test set,
in order to avoid overfitting. This is performed automatically in the \code{"EQRN"} objects.}

\item{scale_features}{Whether to rescale each input covariates to zero mean and unit variance before applying the network (recommended).
If \code{X_scaling} is given, \code{X_scaling$scaling} overrides \code{scale_features}.}
}
\value{
Named list containing:
\item{X_excesses}{the (possibly rescaled and q_feat transformed) covariate matrix,}
\item{X_scaling}{object of class \code{"X_scaling"} to use for consistent scaling on future datasets.}
}
\description{
Feature processor for EQRN
}
