% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ffsql.R
\name{write.odbc.ffdf}
\alias{write.odbc.ffdf}
\title{Write ffdf data to a database table by using a ODBC connection.}
\usage{
write.odbc.ffdf(x, tablename, odbcConnect.args = list(dsn = NULL, uid = "",
  pwd = ""), RECORDBYTES = sum(.rambytes[vmode(x)]),
  BATCHBYTES = getOption("ffbatchbytes"), by = NULL, VERBOSE = FALSE, ...)
}
\arguments{
\item{x}{the \code{\link[ff]{ffdf}} to write to the database}

\item{tablename}{character string with the name of the table to store the data in. Passed on to \code{\link[RODBC]{sqlSave}}.}

\item{odbcConnect.args}{a list of arguments to pass to ODBC's \code{\link[RODBC]{odbcConnect}} (like dsn, uid, pwd). See the examples.}

\item{RECORDBYTES}{optional integer scalar representing the bytes needed to process a single row of the ffdf}

\item{BATCHBYTES}{integer: bytes allowed for the size of the data.frame storing the result of reading one chunk.
See documentation in \code{\link[ff]{read.table.ffdf}} for more details.}

\item{by}{integer passed on to \code{\link[bit]{chunk}} indicating to write to the database in chunks of this size. Overwrites
the behaviour of BATCHBYTES and RECORDBYTES.}

\item{VERBOSE}{logical: TRUE to verbose timings for each processed chunk (default FALSE).}

\item{...}{optional parameters passed on to \code{\link[RODBC]{sqlSave}}}
}
\value{
invisible()
}
\description{
Write \code{\link[ff]{ffdf}} data to a database table by using a ODBC connection.
This can for example be used to store large ffdf datasets from R in
Oracle, SQLite, MySQL, PostgreSQL, Hive or other SQL databases. \cr
Mark that for very large datasets, these SQL databases might have tools to speed up by bulk loading.
You might also consider that as an alternative to using this procedure.
}
\details{
Opens up the ODBC connection using \code{RODBC::odbcConnect}, writes data to the SQL table
using \code{RODBC::sqlSave} by extracting the data in batches from the \code{\link[ff]{ffdf}}
and appending them to the table.
}
\examples{
##
## Using the sqlite database (smalldb.sqlite3) in the /inst folder of the package
## set up the sqlite ODBC driver (www.stats.ox.ac.uk/pub/bdr/RODBC-manual.pd)
## and call it 'smalltestsqlitedb'
##
\dontrun{
require(RODBC)
x <- read.odbc.ffdf(
  query = "select * from testdata limit 10000",
  odbcConnect.args = list(
   dsn="smalltestsqlitedb", uid = "", pwd = "",
   believeNRows = FALSE, rows_at_time = 1),
  nrows = -1,
  first.rows = 100, next.rows = 1000, VERBOSE = TRUE)

write.odbc.ffdf(x = x, tablename = "testdata", rownames = FALSE, append = TRUE,
  odbcConnect.args = list(
   dsn="smalltestsqlitedb", uid = "", pwd = "",
   believeNRows = FALSE, rows_at_time = 1),
  by = 1000, VERBOSE=TRUE)
}
}
\seealso{
\code{\link[RODBC]{sqlSave}}, \code{\link[bit]{chunk}}
}

