% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{nonIntrinsic_mean_tube}
\alias{nonIntrinsic_mean_tube}
\title{Calculate Non-Intrinsic Mean of ETReps}
\usage{
nonIntrinsic_mean_tube(tubes, type = "sizeAndShapeAnalysis", plotting = TRUE)
}
\arguments{
\item{tubes}{List of ETReps.}

\item{type}{String, "ShapeAnalysis" or "sizeAndShapeAnalysis" (default is "sizeAndShapeAnalysis").}

\item{plotting}{Logical, enables visualization of the mean (default is TRUE).}
}
\value{
List representing the mean ETRep.
}
\description{
Computes the non-intrinsic mean of a set of ETReps.
}
\examples{
#Example 1
# Load tubes
data("tube_A")
data("tube_B")
nonIntrinsic_mean<-
  nonIntrinsic_mean_tube(tubes = list(tube_A,tube_B),
                         plotting = FALSE)
# Plotting
plot_Elliptical_Tube(tube = nonIntrinsic_mean,
                     plot_frames = FALSE,
                     plot_skeletal_sheet = FALSE,
                     plot_r_project = FALSE,
                     plot_r_max = FALSE,
                     add = FALSE)

#Example 2
data("simulatedColons")
nonIntrinsic_mean<-
  nonIntrinsic_mean_tube(tubes = simulatedColons,
                         plotting = FALSE)
# Plotting
plot_Elliptical_Tube(tube = nonIntrinsic_mean,
                     plot_frames = FALSE,
                     plot_skeletal_sheet = FALSE,
                     plot_r_project = FALSE,
                     plot_r_max = FALSE,
                     add = FALSE)
}
