\name{nuclearWeaponStates}
\docType{data}
\alias{nuclearWeaponStates}
\encoding{UTF-8}
\title{Nations with nuclear weapons}
\description{
  Data on the 9 nuclear-weapon states as of 
  April 2019.  
}
\usage{data(nuclearWeaponStates)}
\format{A dataframe containing :
  \describe{
    \item{nation}{
      The name of the country (character).  
      The former USSR is listed here as Russia.  
    }
    \item{ctry}{
      \href{https://en.wikipedia.org/wiki/ISO_3166-1#cite_note-iso3166-info-1}{ISO 31661-} alpha-2 two-letter country codes 
      (character).}
    \item{firstTest}{
      Date of first test of a nuclear weapon.  
      
      For Israel, which has not publicly acknowledged
      that it has nuclear weapons, this uses the Date 
      of the 
      \href{https://en.wikipedia.org/wiki/Vela_Incident}{Vela Incident}.  
    }
    \item{firstTestYr}{
      \code{lubridate::decimal_date(firstTest)}
    }
    \item{yearsSinceLastFirstTest}{
      \code{c(NA, diff(firstTestYr))}
    }
    \item{nuclearWeapons}{
      number of nuclear weapons 
    }
    \item{nYieldNA, nLowYield, nMidYield, nHighYield}{
      number of weapons for which the yield in 
      \code{(nYieldNA)} = unknown or variable, 
      \code{(nLowYield)} = at most 15 kt 
      (kilotons), the size of the Hiroshima 
      bomb, \code{(nMidYield)} = greater than 15 
      but less that 50 kt, and \code{(nHighYield)} 
      = at least 50 kt.  
    }
    \item{popM, popYr}{
      \code{popM} = estimated population in millions 
      for year \code{popYr}, per the Wikipedia 
      article for the indicated country on 2020-02-05.  
    }
    \item{GDP_B,	GDPyr}{
      \code{GDP_B} = nominal Gross Domestic Product 
      in billions of US dollars for year 
      \code{GDPyr}, per the Wikipedia article for 
      the indicated country on 2020-02-05. 
    }
    \item{Maddison}{
      Country code used by the 
      \href{https://en.wikipedia.org/wiki/Maddison_Project}{Maddison Project}.
    }
    \item{startNucPgm}{
      Estimated date of the substantive commitment 
      of the country to obtain nuclear weapons. See 
      'Details' below  
    }
    \item{startNucPgmYr}{
      \code{lubridate::decimal_date(startNucPgm)}
    }
  }
}
\details{
  Most of the contents of this dataset are 
  easily defined and not controversial.  That's 
  not true for the date upon which each country 
  started its nuclear program, coded in 
  \code{startNucPgm} and \code{startNucPgmYr}.  
  The following summarizes the rationale behind 
  the selection of the date for each country in 
  this dataset.  
  
  \itemize{
    \item{\code{US}}{
      The \href{https://en.wikipedia.org/wiki/Manhattan_Project}{Manhattan Project} started in
      stages. It was officially brought to the
      attention of the US government by a 
      letter officially from 
      \href{https://commons.wikimedia.org/wiki/File:Einstein-Roosevelt-letter.png}{Albert Einstein to US President Roosevelt}, 1939-08-02.  
      It was officially authorized 
      \href{https://en.wikipedia.org/wiki/Timeline_of_the_Manhattan_Project}{1942-01-19}. 
      We use this later date as the date of the 
      start of the US nuclear-weapons program.
    }
    \item{\code{RU}}{
      Russian scientists were studying uranium 
      before the first world war but didn't get 
      much official attention until the atomic
      bombing of Hiroshima, 1945-08-06.  Shortly
      thereafter on 
      \href{https://en.wikipedia.org/wiki/Soviet_atomic_bomb_project}{1945-08-22}, 
      Stalin appointed \href{https://en.wikipedia.org/wiki/Lavrentiy_Beria}{Lavrentiy Beria}.  Beria 
      was a able administrator and guided the 
      project to fruition in four years.    
    }
    \item{\code{GB}}{
      British scientists were among the leaders 
      in nuclear technology in the late 
      nineteenth century.  They welcomed 
      German-Jewish physicists 
      \href{https://en.wikipedia.org/wiki/Otto_Robert_Frisch}{Otto Frisch} and 
      \href{https://en.wikipedia.org/wiki/Rudolf_Peierls}{Rudolf Peierls}, who estimated 
      in 1939 that only 
      \href{https://en.wikipedia.org/wiki/Frisch-Peierls_memorandum}{a few pounds or kilograms of uranium-235 might be enough to achieve a critical mass, whereas several tonnes of natural uranium would likely be required}. 
      Because of the war, this information was 
      passed to scientists in the United States, 
      who developed it into the bomb dropped on
      Hiroshima 
      \href{https://en.wikipedia.org/wiki/Atomic_bombings_of_Hiroshima_and_Nagasaki}{1945-08-06}, 
      with help from British and Canadian 
      scientists and Canadian industry.  After 
      the war, the US refused to share much of 
      the information developed in the Manhattan
      Project with the British.  British elites 
      felt disrespected by US.  On 
      \href{https://en.wikipedia.org/wiki/Nuclear_weapons_and_the_United_Kingdom#Resumption_of_independent_UK_efforts}{1947-01-08}, 
      the British government decided to 
      initiate their own nuclear-weapons program.  
    }
    \item{\code{FR}}{
      France was one of the nuclear pioneers, 
      going back to the work of 
      \href{https://en.wikipedia.org/wiki/Marie_Curie}{Marie Curie} and 
      \href{https://en.wikipedia.org/wiki/Henri_Becquerel}{Henri Becquerel} in the 
      1890s.  In 1956 the French were deeply 
      offended by the refusal of the US to 
      support them in the 
      \href{https://en.wikipedia.org/wiki/Suez_Crisis}{Suez Crisis}.  
      On \href{https://fas.org/nuke/guide/israel/nuke/farr.htm}{France and Israel secretly agreed to
      collaborate in the development of nuclear
      weapons}.  
    }
    \item{\code{CN}}{
      \href{https://en.wikipedia.org/wiki/China_and_weapons_of_mass_destruction#History}{Mao Zedong reportedly decided to begin a Chinese nuclear-weapons program} 
      during the 
      \href{https://en.wikipedia.org/wiki/First_Taiwan_Strait_Crisis#Aftermath:_China_and_nuclear_weapons}{First Taiwan Strait Crisis of 1954–1955}.  
      That crisis was resolved shortly after
      \href{https://en.wikipedia.org/wiki/First_Taiwan_Strait_Crisis#Aftermath:_China_and_nuclear_weapons}{1955-04-23}, 
      when China stated it was willing to 
      negotiate.  We use this as the date of the
      start of China's nuclear weapons program.  
    }
    \item{\code{IN}}{
      Indian scientists started research on 
      nuclear weapons before Indian independence 
      but didn't make a substantive commitment 
      to actually making a nuclear weapon until 
      they lost territory to China in the 
      \href{https://en.wikipedia.org/wiki/Sino-Indian_War}{Sino-Indian War} 
      that ended 1962-11-21.  We use that date as 
      the date for the initiation of India's 
      nuclear-weapons program.  
    }
    \item{\code{IL}}{ 
      Israel's first Prime Minister David 
      Ben-Gurion was reportedly "nearly obsessed"
      with obtaining nuclear weapons to prevent 
      the Holocaust from recurring.  For present
      purposes, we use 1949-03-10, the date of 
      the end of the 
      \href{https://en.wikipedia.org/wiki/1948_Arab-Israeli_War}{1948 Arab–Israeli War}, 
      as the beginning of Israel's 
      nuclear-weapons program.  
    }
    \item{\code{PK}}{
      Pakistan's elite were totally humiliated 
      by their defeat in the 
      \href{https://en.wikipedia.org/wiki/Indo-Pakistani_War_of_1971}{Indo-Pakistani War of 1971},
      1971-12-03 / -16: That war ended the
      \href{https://en.wikipedia.org/wiki/Bangladesh_Liberation_War}{Bangladesh Liberation War}, 
      by which Pakistan lost over half their population and 14 percent of their land area.   
      Prime Minister Zulfiqar Ali Bhutto compared
      Pakistan's surrender to the Treaty of
      Versailles, which Germany was forced to sign 
      in 1919. Bhutto observed 1972-01-20 that a
      Pakistani scientist had been part of the
      Manhattan Project, and Pakistani scientists
      could do the same in Pakistan.  While
      significant funding seemed not to have come
      until later, 1972-01-20 is the date we will 
      use here for the beginning of Pakistan's
      nuclear-weapons program.  
    }
    \item{\code{KP}}{
      The 1950-1953 Korean War ended with a 
      cease-fire, not an official end to 
      hostilities.  Since then North Korea has
      perceived nuclear threats from the US.  In 
      1956 the Soviet Union began giving North 
      Korean scientists and engineers "basic
      knowledge" to help them initiate a 
      nuclear program.  About 1962, 
      \href{https://www.washingtonpost.com/news/monkey-cage/wp/2016/02/18/these-5-things-help-make-sense-of-north-koreas-nuclear-tests-and-missile-launch/}{North Korea committed itself to what it called "all-fortressization"}, 
      which was the beginning of the 
      hyper-militarized North Korea of today.  
      North Korea reportedly asked the Soviet 
      Union for help with a nuclear weapons 
      program in 1963 and was turned down.  China
      turned down similar requests in 1964 and 
      1974.  Around 1980 North Korea began mining 
      its own supplies of uranium and building 
      its own factory to produce 
      \href{https://en.wikipedia.org/wiki/Yellowcake}{yellowcake}.  
      (See also Bolton, 2012.)  For lack of 
      something better, we use 1980-01-01 as the
      start of North Korea's nuclear weapons 
      program.  They clearly wanted nuclear 
      weapons much earlier but didn't seem to 
      move seriously in the direction of 
      developing nuclear weapons until around 
    }
  }
}
\source{
  Overview from \href{https://www.ploughshares.org/world-nuclear-stockpile-report}{World Nuclear Weapon Stockpile}
  
  \code{firstTest} from \href{https://en.wikipedia.org/wiki/List_of_states_with_nuclear_weapons}{Wikipedia, "List of states with nuclear weapons"}

  US from \href{https://www.tandfonline.com/doi/pdf/10.1080/00963402.2018.1438219?needAccess=true}{Hans M. Kristensen & Robert S. Norris (2018) United States nuclear forces,2018, Bulletin of the Atomic Scientists, 74:2, 120-131, DOI: 10.1080/00963402.2018.143821}
  
  Russia from \href{https://www.tandfonline.com/doi/pdf/10.1080/00963402.2019.1580891?needAccess=true}{Hans M. Kristensen & Matt Korda (2019) Russian nuclear forces, 2019, Bulletin of the Atomic Scientists, 75:2, 73-84, DOI: 10.1080/00963402.2019.1580891}
  
  UK from \href{https://journals.sagepub.com/doi/pdf/10.1177/0096340213493260}{Robert S. Norris and Hans M. Kristensen (2013) The British nuclear stockpile, 1953-2013, Bulletin of the Atomic Scientists, 69:4, 69-75s}
  
  France from \href{https://journals.sagepub.com/doi/pdf/10.2968/064004012}{Robert S. Norris & Hans M. Kristensen (2008) French nuclear forces, 2008, Bulletin of the Atomic Scientists, 64:4, 52-54, 57}  
  
  China from \href{https://www.tandfonline.com/doi/pdf/10.1080/00963402.2018.1486620?needAccess=true}{Hans M. Kristensen & Robert S. Norris (2018) Chinese nuclear forces, 2018,Bulletin of the Atomic Scientists, 74:4, 289-295}
  
  India from \href{https://www.tandfonline.com/doi/pdf/10.1080/00963402.2017.1337998?needAccess=true}{ Hans M. Kristensen & Robert S. Norris (2017) Indian nuclear forces, 2017,Bulletin of the Atomic Scientists, 73:4, 205-209}
  
  Israel from \href{https://journals.sagepub.com/doi/pdf/10.1177/0096340214555409}{Hans M. Kristensen and Robert S. Norris (2014) Israeli nuclear weapons, 2014, Bulletin of the Atomic Scientists, 70:6, 97-115}
  
  Pakistan from \href{https://www.tandfonline.com/doi/pdf/10.1080/00963402.2018.1507796?needAccess=true}{Hans M. Kristensen, Robert S. Norris & Julia Diamond (2018)Pakistani nuclear forces, 2018, Bulletin of the Atomic Scientists, 74:5, 348-358}
  
  North Korea from \href{https://www.tandfonline.com/doi/pdf/10.1080/00963402.2017.1413062?needAccess=true}{ Hans M. Kristensen & Robert S. Norris (2018) North Korean nuclear capabilities, 2018, Bulletin of the Atomic Scientists, 74:1, 41-51}

  Derek Bolton (2012) North Korea's Nuclear Program (2012-08, American Security Program, accessed 2020-07-15) \url{https://www.americansecurityproject.org/ASP\%20Reports/Ref\%200072\%20-\%20North\%20Korea’s\%20Nuclear\%20Program\%20.pdf}
}
\examples{
data(nuclearWeaponStates)
plot(yearsSinceLastFirstTest~firstTest, 
    nuclearWeaponStates, type='h', xlab='', ylab='')
with(nuclearWeaponStates, 
  text(firstTest, yearsSinceLastFirstTest, ctry))
}
\keyword{datasets}
