% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.forestplot.R
\docType{methods}
\name{eco.forestplot}
\alias{eco.forestplot}
\alias{eco.forestplot,eco.getismoran-method}
\alias{eco.forestplot,eco.gm,ANY-method}
\alias{eco.forestplot,eco.multiboot,character-method}
\alias{eco.forestplot,eco.multiboot-method}
\title{Plot for correlograms of Getis- Ord's G or local-Moran's I}
\usage{
eco.forestplot(input, var)

\S4method{eco.forestplot}{eco.multiboot,character}(input, var)

\S4method{eco.forestplot}{eco.gm,ANY}(input)
}
\arguments{
\item{input}{Getis-Ord's G or local-Moran's I analysis result of
\code{\link{eco.autocor}}, \code{\link{eco.localmoran}} or
\code{\link{eco.getisord}}.}

\item{var}{Variable to plot when an  \code{\link{eco.autocor}}
result should be plotted.}
}
\description{
In the case of \code{\link{eco.autocor}} results, this
function generates a forest plot for a given interval
class distance. The program asks for the interval and generates a plot
with the confidence interval for each individual (as row number)
and the corresponding observed value of the statistic.
For \code{\link{eco.localmoran}} or \code{\link{eco.getisord}} results,
the program also generates a forest plot with confidence intervals
and the values of the observed statistic.
}
\examples{
\dontrun{
data(eco.test)
eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "P", select = "getisord", nsim = 10, indvar="P6")
eco.forestplot(eco.ac, "P6")

require(adegenet)
con<-chooseCN(eco$XY, type = 1, result.type = "listw",
plot.nb = FALSE)
getis <- eco.getisord(eco$P[, 3], con, nsim = 99, classG = "G*",
test = "bootstrap")
eco.forestplot(getis)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

