% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.split.R
\name{eco.split}
\alias{eco.split}
\title{Splitting an ecogen object by group}
\usage{
eco.split(
  eco,
  hier,
  name = NULL,
  overwrite = FALSE,
  missing = c("0", "NA", "MEAN"),
  asList = TRUE
)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{hier}{The name of the S slot column with labels assigning individuals to groups.}

\item{name}{Name used for the output objects. Default is the name of the input,followed by
a suffix (see Description).}

\item{overwrite}{Overwrite files with the same name of the output
if already present in workspace when asList = FALSE? Default FALSE.}

\item{missing}{Missing data argument This can take three values ("0", "NA" or "MEAN"),
as described in  \code{\link{ecogen}}. 
#' Missing elements are treated as zeros in the default option.}

\item{asList}{Return a list with the objects instead of creating objects in workspace?
Default = TRUE}
}
\description{
The function splits an ecogen object into the groups defined
in the slot S. If asList is TRUE, a list with the objects is created , 
that can be assigned to a name with regular rules, using the operator "<-". 
Otherwise, the function creates in the workspace an ecogen object for each group 
with the following nomenclature: <name of ecogen object>.<name of the group>.
}
\examples{
\dontrun{
data(eco3)
eco3


# list of objects
x <- eco.split(eco3, "structure", asList = TRUE)


# rebinding
eco.bind <- eco.rbind(x)


# note that different subsets can also be created
S1.3 <- eco.rbind(x[[1]], x[[3]])


# split and create objects with prefix "eco3"
eco.split(eco3,"structure", asList = FALSE)


# split and create objects with prefix "newObjects"
eco.split(eco3,"structure", "newObjects", asList = FALSE) 



}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
