% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{size_uniform_user}
\alias{size_uniform_user}
\title{SizeUser Size Overlap Randomization Algorithm}
\usage{
size_uniform_user(speciesData = runif(n = 20), userLow = 0.9 *
  min(speciesData), userHigh = 1.1 * max(speciesData))
}
\arguments{
\item{speciesData}{a vector of observed body sizes.}

\item{userLow}{a user-defined lower limit.}

\item{userHigh}{a user-defined upper limit.}
}
\value{
Returns a vector of randomized body sizes.
}
\description{
Observed body sizes are randomized with a uniform distribution
for which the user has defined the minimum and maximum possible body size.
}
\details{
Within the user-defined limits, body sizes of all n species are
randomized, whereas uniform_size randomizes only n - 2 of the body
sizes and uses the extreme values to set the endpoints.
}
\note{
As the difference between the lower and upper boundaries is increased
the test will yield results that are random or aggregated, even though the
same data might yield a segregated pattern when the uniform_size algorithm
is used. For this reason, this algorithm is not recommended for size ratio
analyses.
}
\examples{
nullSizes <- size_uniform_user(speciesData=runif(20,min=10,max=20),userLow=8,userHigh=24)
}
\seealso{
\code{\link{size_uniform}} size distribution algorithm.
}

