% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelsSDF.R
\name{levelsSDF}
\alias{levelsSDF}
\title{Get the levels and labels of a variable in an edsurvey.data.frame or light.edsurvey.data.frame.}
\usage{
levelsSDF(varnames, data)
}
\arguments{
\item{varnames}{a vector of character strings to search for in the database connection object (\code{data}).}

\item{data}{object of class \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame} (see \code{\link{readNAEP}}
for how to generate an \code{edsurvey.data.frame}).}
}
\value{
A pasted statement that shows the levels and labels of a variable (or vector of variables)
        from an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.
}
\description{
\code{levelsSDF} returns a \ifelse{latex}{\code{data.frame}}{\code{\link[base]{data.frame}}} that shows the levels and
labels of a variable from an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}..
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# search variables in the sdf
levelsSDF("pared",sdf)

# search multiple variables
levelsSDF(c("pared","ell3"),sdf)

# search multiple variables in a light.edsurvey.data.frame with recodes
df2 <- getData(sdf, c("dsex", "t088301"),
	recode=list(
		t088301=list(
			from=c("Yes, available","Yes, I have access"),
			to=c("Yes")),
		t088301=list(from=c("No, have no access"),
			to=c("No"))),
	addAttributes=TRUE)
levelsSDF(c("dsex","t088301"),df2)
}
\author{
Michael Lee and Paul Bailey
}
