% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readECLS_K2011.R
\name{readECLS_K2011}
\alias{readECLS_K2011}
\title{Connect to ECLS-K 2011 Data}
\usage{
readECLS_K2011(path = getwd(), filename = "childK4p.dat",
  layoutFilename = "ECLSK2011_K4PUF.sps", forceReread = FALSE,
  verbose = TRUE)
}
\arguments{
\item{path}{a character value to the full directory path(s) to the ECLS-K 2010-11 extracted fixed-with-format (.dat) set of data files}

\item{filename}{a character value of the name of the fixed-width-file (.dat) data file in the specified \code{path} to be read}

\item{layoutFilename}{a character value of the filename of either the ASCII text (.txt) layout file of the \code{filename} within the specified \code{path},
OR a character value of the  filename of the SPSS syntax (.sps) layout file of the \code{filename} within the specified \code{path}}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output while the \code{readECLS-K2011} function is running to indicate processing progress.
The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for the ECLS-K 2010-11 longitudinal dataset
}
\description{
Opens a connection to an ECLS-K 2011 data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the ECLS-K 2010-11 longitudinal database.
}
\examples{
\dontrun{
#read-in student file with defaults
eclsk_df <- readECLS_K2011(path="C:/ECLS_K/2011") #using defaults
d <- getData(eclsk_df, c("childid", "c1hgt1", "c1wgt1"))
summary(d)

#read-in with parameters specified
eclsk_df <- readECLS_K2011(path = "C:/ECLS_K2011",
                           filename = "childK4p.dat",
                           layoutFilename = "ECLSK2011_K4PUF.sps",
                           forceReread = FALSE,
                           verbose = TRUE) 
}
}
\seealso{
\code{\link{readECLS_K1998}}, \code{\link{readNAEP}}, \code{\link{getData}}, and \code{\link{downloadECLS_K}}
}
\author{
Tom Fink
}
