% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTIMSS.R
\name{downloadTIMSS}
\alias{downloadTIMSS}
\title{Download and Unzip TIMSS Files}
\usage{
downloadTIMSS(
  root,
  years = c(2003, 2007, 2011, 2015, 2019),
  cache = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{root}{a character string indicating the directory where the TIMSS
data should be stored. Files are placed in a
subdirectory named TIMSS/[year].}

\item{years}{an integer vector of the assessment years to download. Valid years are 2003, 2007, 2011,
2015, and 2019.}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of
the data. Default value is \code{FALSE}.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\description{
Uses an Internet connection to download TIMSS data.
             Data come from \href{https://timssandpirls.bc.edu/}{timssandpirls.bc.edu} zip files. This
             function works for 2003, 2007, 2011, 2015, and 2019 data.
}
\examples{
\dontrun{
# root argument will vary by operating system conventions
downloadTIMSS(year=c(2019, 2015, 2011), root = "~/")

# cache=TRUE will download then process the datafiles
downloadTIMSS(year=2015, root = "~/", cache = TRUE)

# set verbose=FALSE for silent output
# if year not specified, download all years
downloadTIMSS(root="~/", verbose = FALSE)
}
}
\seealso{
\code{\link{readTIMSS}}
}
\author{
Tom Fink
}
