% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_round.R
\name{es_round}
\alias{es_round}
\title{round ouptut of EdSurvey functions before printing}
\usage{
es_round(
  object,
  round_n = getOption("EdSurvey_round_n_function"),
  round_pop_n = getOption("EdSurvey_round_pop_n_function"),
  round_est = getOption("EdSurvey_round_est_function"),
  round_est_se = getOption("EdSurvey_round_est_se_function"),
  round_pct = getOption("EdSurvey_round_pct_function"),
  round_pct_se = getOption("EdSurvey_round_pct_se_function"),
  round_specific_element = NULL,
  ...
)
}
\arguments{
\item{object}{the object (usually the result of an analysis function) to be rounded}

\item{round_n}{function used to round sample n-sizes}

\item{round_pop_n}{function used to round weighted n-sizes, these are also called population size estimates}

\item{round_est}{function used to round estimates; examples include means and percentiles of scores, as well as regression coefficients}

\item{round_est_se}{function used to round standard errors of estimates}

\item{round_pct}{function used to round percentages}

\item{round_pct_se}{function used to round the standard errors of percentages}

\item{round_specific_element}{a list of rounding functions, the function is applied to elements with that name. See Examples}

\item{...}{additional arguments passed to methods

rounds every statistic that is a function of data, including the header and tables}
}
\value{
the object is returned, with relevant elements rounded
}
\description{
Applies rounding rules
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(path=system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# by default uses jackknife variance method using replicate weights
es1 <- edsurveyTable(formula=composite ~ dsex + b017451, data=sdf)
# turn on rounding by default
options(EdSurvey_round_output= TRUE)
es1
# turn off rounding by default
options(EdSurvey_round_output= FALSE)

# request rounding for this outpt
print(es1, use_es_round=TRUE)
# round, then print

# round the PCT column to one digit
es_round(es1, round_specific_element=list(PCT=roundn(1)))

}
}
\author{
Paul Bailey
}
