% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EleChemr.R
\name{CVEE}
\alias{CVEE}
\title{EE behaviour cyclic voltammetry simulator}
\usage{
CVEE(Co = 0.001, Dx1 = 1e-05, Eo1 = 0.1, Vi = 0.3, Vf = -0.3,
  Vs = 0.001, ko1 = 0.01, alpha1 = 0.5, Dred = 1e-05,
  Dred2 = 1e-05, Eo2 = 0.05, ko2 = 0.01, alpha2 = 0.5, Dm = 0.45,
  Temp = 298.15, n = 1, Area = 1, DerApprox = 2,
  errCheck = FALSE, Method = "Euler")
}
\arguments{
\item{Co}{bulk concentration}

\item{Dx1}{diffusion coefficient of the oxidized species}

\item{Eo1}{reduction potential of the first electrochemical reaction}

\item{Vi}{initial potential of the sweep}

\item{Vf}{final potential of the sweep}

\item{Vs}{potential scan rate of the simulation}

\item{ko1}{heterogeneous electron transfer rate constant of the first electrochemical reaction}

\item{alpha1}{charge transfer coefficient of the first electrochemical reaction}

\item{Dred}{diffusion coefficient of the first reduced species}

\item{Dred2}{diffusion coefficient of the second reduced species}

\item{Eo2}{reduction potential of the second electrochemical reaction}

\item{ko2}{heterogeneous electron transfer rate constant of the second electrochemical reaction}

\item{alpha2}{charge transfer coefficient of the second electrochemical reaction}

\item{Dm}{simulation parameter, maximum 0.5 for explicit methods}

\item{Temp}{temperature in kelvin}

\item{n}{number of electrons involved in the process}

\item{Area}{area of the electrode}

\item{DerApprox}{number of point for the approximation of the first derivative}

\item{errCheck}{if true the function returns a list with parameters for CottrCheck function}

\item{Method}{method to be used for the simulation = "Euler" "BI" "RK4" "CN "BDF"}
}
\value{
if errCheck == F a graph I vs E, if errCheck == T a list
}
\description{
Return a graph I vs E of the electrochemical process
}
\examples{
CVEE(Co = 0.001, DerApprox = 2, Dm = 0.45, errCheck = FALSE, Method = "Euler")
CVEE(Co = 0.001, Eo2 = -0.15, Dm = 0.45)

}
