% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Derivative.R
\name{Derv}
\alias{Derv}
\title{Derivative calculation of concentration profile}
\usage{
Derv(npoints = 2, h, Ox, mode = "Forward", Derivative = "First",
  CoefMat = FALSE)
}
\arguments{
\item{npoints}{number of points to be used for the derivative}

\item{h}{space for the finite difference}

\item{Ox}{data upon the derivative is calculated}

\item{mode}{"Forward" or "Backward" the derivative will be calculated for the npoints}

\item{Derivative}{"First" or "Second" derivative to calculate}

\item{CoefMat}{if T return the derivative coefficient matrix for selected derivative}
}
\value{
a vector with the derivative requested or the coefficient of such derivative
}
\description{
Return a the derivative of the concentration profile simulated
}
\examples{
Derv(npoints = 2, h = 0.13, Ox = matrix(c(1,2), nrow = 1), mode = "Forward", Derivative = "First")

}
