% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EleChemr.R
\name{PotStep}
\alias{PotStep}
\title{Chrono amperometry with a finite step digital simulation}
\usage{
PotStep(Co = 0.001, exptime = 1, Dx = 1e-05, Dm = 0.45,
  eta = 0.1, Temp = 298.15, n = 1, Area = 1, DerApprox = 2,
  errCheck = FALSE, Method = "Euler")
}
\arguments{
\item{Co}{bulk concentration}

\item{exptime}{experimental time to be simulated}

\item{Dx}{diffusion coefficient}

\item{Dm}{simulation parameter, maximum 0.5 for explicit methods}

\item{eta}{overpotential of the step}

\item{Temp}{temperature in kelvin}

\item{n}{number of electrons involved in the process}

\item{Area}{area of the electrode}

\item{DerApprox}{number of point for the approximation of the first derivative}

\item{errCheck}{if true the function returns a list with parameters for CottrCheck function}

\item{Method}{method to be used for the simulation = "Euler" "BI" "RK4" "CN" "BDF"}
}
\value{
if errCheck == F a graph I vs t, if errCheck == T a list
}
\description{
Return a graph I vs t of the electrochemical process
}
\examples{
PotStep(Co = 0.001, exptime = 1, Dm =0.45, DerApprox = 2, errCheck = FALSE, Method = "Euler")

}
