% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__MFO.R
\name{config_mfo}
\alias{config_mfo}
\title{Configuration object for the Moth-flame Optimization Algorithm}
\usage{
config_mfo(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of moths.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}
}
\value{
\code{config_mfo} returns an object of class \code{MFOConfig}.
}
\description{
Create a configuration object for the Moth-flame Optimization Algorithm (MFO). At minimum the number of iterations
(parameter \code{iterations}) and the number of moths (parameter \code{population_size}) have
to be provided.
}
\references{
\insertRef{Mirjalili2015}{EmiR}
}
