% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emission.R
\name{emission}
\alias{emission}
\title{Emissions in the format for atmospheric models}
\format{matrix of emission}
\usage{
emission(
  total,
  pol,
  area,
  grid,
  inventory = NULL,
  mm = 1,
  aerosol = F,
  plot = F,
  positive = T,
  verbose = T
)
}
\arguments{
\item{total}{list of total emission}

\item{pol}{pollutant name}

\item{area}{list of area sources or matrix with a spatial distribution}

\item{grid}{grid information}

\item{inventory}{a inventory raster from read}

\item{mm}{pollutant molar mass}

\item{aerosol}{TRUE for aerosols and FALSE (defoult) for gazes}

\item{plot}{TRUE for plot the final emissions}

\item{positive}{TRUE (defoult) to check negative values and replace for zero}

\item{verbose}{display additional information}
}
\description{
Combine area sources and total emissions to model output
}
\note{
if Inventory is provided, the firsts tree arguments are not be used by the funciton.

Is a good practice use the set_units(fe,your_unity), where fe is your emission factory and your_unity is usually g/km on your emission factory

the list of area must be in the same order as defined in vehicles and total emission.

just WRF-Chem is suported by now
}
\examples{
fleet  <- vehicles(example = TRUE)

EmissionFactors <- emissionFactor(example = TRUE)

TOTAL  <- totalEmission(fleet,EmissionFactors,pol = c("CO"),verbose = TRUE)

grid   <- gridInfo(paste0(system.file("extdata", package = "EmissV"),"/wrfinput_d01"))
shape  <- raster::shapefile(paste0(system.file("extdata", package = "EmissV"),"/BR.shp"))
raster <- raster::raster(paste0(system.file("extdata", package = "EmissV"),"/dmsp.tiff"))

SP     <- areaSource(shape[22,1],raster,grid,name = "SP")
RJ     <- areaSource(shape[17,1],raster,grid,name = "RJ")

e_CO   <- emission(TOTAL,"CO",list(SP = SP, RJ = RJ),grid,mm=28)

}
\seealso{
\code{\link{totalEmission}} and \code{\link{areaSource}}
}
