% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaxSprtCriticalValues.R
\name{computeCvBinomial}
\alias{computeCvBinomial}
\title{Compute critical values for Binomial data}
\usage{
computeCvBinomial(
  groupSizes,
  z,
  minimumEvents = 1,
  alpha = 0.05,
  sampleSize = 1e+06,
  nullMean = 0,
  nullSd = 0
)
}
\arguments{
\item{groupSizes}{Vector containing the expected number of events under H0 for each test.}

\item{z}{For a matched case-control analysis, z is the number of controls matched to
each case under the null hypothesis. For a self-controlled analysis, z is the
control time divided by the time at risk.}

\item{minimumEvents}{The minimum number of events needed before the null hypothesis can be rejected.}

\item{alpha}{The significance level, or the type 1 error probability, which is the probability
of rejecting the null hypothesis when it is true.}

\item{sampleSize}{Sample size for the Monte-Carlo simulations.}

\item{nullMean}{The mean of the empirical null distribution.}

\item{nullSd}{The standard deviation of the empirical null distribution.}
}
\value{
The computed critical value. The 'alpha' attribute of the result indicates the selected alpha.
}
\description{
Obtains critical values for the group and continuous sequential MaxSPRT test with Binomial data,
using a Wald type upper boundary, which is flat with respect to the likelihood ratio function,
and with a pre-specified upper limit on the sample size.

It is often not possible to select a critical value that corresponds to the exact alpha specified.
Instead, this function will select the least conservative critical value having an alpha below
the one specified, so the sequential analysis is conservative.

This function is a re-implementation of the \code{CV.Binomial} function in the \code{Sequential}
package, using Monte-Carlo.
}
\examples{
groupSizes <- rep(1, 10)
computeCvBinomial(groupSizes, z = 4)

}
