% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aso_odds_ratio_function_repeated.R
\name{odds_ratio_function_repeated}
\alias{odds_ratio_function_repeated}
\title{Wrapper for the \code{odds_ratio_function()}to perform several similar analyses
in one go}
\usage{
odds_ratio_function_repeated(
  normaldata,
  outcomevar,
  expvars,
  adjustment_fixed = NULL,
  by_var = NULL,
  number_decimals = 2,
  alpha = 0.05,
  regtype = c("logistic", "log-linear"),
  matchgroup = NULL,
  matchtiemethod = c("exact", "approximate", "efron", "breslow"),
  values_to_remove = NULL,
  weightvar = NULL,
  surveydata = FALSE,
  textvar = NULL,
  model_object = FALSE
)
}
\arguments{
\item{normaldata}{A data frame or data frame extension (e.g. a tibble).}

\item{outcomevar}{A character vector naming factor variables in normaldata
to use as outcomes in separate models.}

\item{expvars}{A character vector naming exposure variables (either numeric
or factors) to use in separate models.}

\item{adjustment_fixed}{A character vector naming adjustment variables to
include in all models. NULL is the default resulting in no fixed
adjustment.}

\item{by_var}{A character vector specifying a factor on which to run the
analyses completely separate for all levels. It only works with one
variable (default is NULL). NOTE: NA and "" levels will not be used but all
other levels will have separate models.}

\item{number_decimals}{An integer giving the number of decimals to show in
the standardized output (default is two decimals).}

\item{alpha}{A scalar, between 0 and 1 specifying the desired significance
level of the confidence intervals (default is 0.05 which will yield the
usual 95\% confidence interval).}

\item{regtype}{A character string specifying the analysis method. Can either
be "logistic" for logistic regression (the default) or "log-linear" for
log-linear regression. Log-linear regression can only be used with
binomial, unconditional analysis.}

\item{matchgroup}{Character string specifying a variable in normaldata to
condition the analysis on. Can only be used in binomial logistic regression
models (default is NULL).}

\item{matchtiemethod}{Character string specifying the method for ties when
using a matched/conditional analysis. The default options is "exact",
however this option does not take weights into account for the analysis, so
if weights (other than 1) are used, another option should be selected.
Other options are "approximate", "efron", and "breslow" - for further
explanations, see documentation for \link[survival]{clogit}.}

\item{values_to_remove}{Character vector specifying values to remove from
ALL variables used in the regression before the analysis (default is NULL).
This is useful if some value(s) are used consistently to encode
missing/irrelevant in the data (e.g. c("888", "987") - normal missing (NA)
don't need to be specified as it will be removed automatically. Do NOT
remove the reference values as this will lead to unexpected results!}

\item{weightvar}{A character string specifying a numeric variable in
normaldata with pre-calculated weights for observations in the analysis.
The default value NULL corresponds to weight 1 for all observations.}

\item{surveydata}{A Boolean specifying whether the data comes from a survey
(default is FALSE).}

\item{textvar}{A character string with text (like a note) to be added to the
output. The default value NULL corresponds to no added note.}

\item{model_object}{A Boolean. If TRUE, returns the raw output object from
the analysis instead of the standard output. This might be useful to see
information not included in the standardized output (default is FALSE).}
}
\value{
A standardized analysis object with results from multiple models.
}
\description{
The function is intended to make it easy to get OR's for several similar
models in one go, where either the same analysis is performed except for one
variable or the same analysis is performed but by each variable (each level
of the variable is analysed separately).
}
\details{
It's possible to have same variable in \code{expvars} and
\code{adjustment_fixed}.

When a model results in an error, the function will not stop - it continues
with other models until done BUT in the output the error text can be seen.
}
\examples{
# Data to use
data("infert", package = "datasets")
infert2 <- infert |>
  dplyr::mutate(
    Age_grp = relevel(as.factor(dplyr::case_when(
      age < 25 ~ "<25",
      25 <= age & age < 35 ~ "25-<35",
      age >= 35 ~ "35+"
    )), ref="25-<35"),
    Parity_grp = relevel(as.factor(dplyr::case_when(
      parity == 1 ~ "1",
      parity >= 2 & parity <= 3 ~ "2-3",
      parity > 3 ~ "4+"
    )), ref="2-3"),
    induced = relevel(as.factor(induced), ref="0"),
    case = relevel(as.factor(case), ref="0"),
    spontaneous = relevel(as.factor(spontaneous), ref="0")
  )

# Two outcomes (Parity_grp, case) with their own set of models, three
# variables included in separate models (spontaneous,induced and education)
# and one variable that is included in all models (Age_grp)
test <- odds_ratio_function_repeated(
  normaldata = infert2,
  outcomevar = c("Parity_grp","case"),
  expvars = c("spontaneous","induced","education"),
  adjustment_fixed = c("Age_grp")
)

# One outcome (case), two variables included in separate models
# (spontaneous and induced), one variable included in all models (Age_grp)
# and all analyses made for each level of another variable (Parity_grp)
test2 <- odds_ratio_function_repeated(
  normaldata = infert2,
  outcomevar = c("case"),
  expvars = c("spontaneous","induced"),
  adjustment_fixed = c("Age_grp"),
  by_var = "Parity_grp"
)

}
\seealso{
\code{\link[=odds_ratio_function]{odds_ratio_function()}} to perform a single logistic or log-linear
regression giving a standardized output table.
}
\author{
ASO
}
