EpiLPS: a fast and flexible Bayesian tool for estimation of the
time-varying reproduction number
================
Oswaldo Gressani (<oswaldo.gressani@uhasselt.be>)

<!-- Introduce badges -->

![Version](https://img.shields.io/badge/Version-1.1.0-MediumSeaGreen)
![Languages](https://img.shields.io/badge/Languages-R%2C%20C%2B%2B-informational)
![Lifecycle](https://img.shields.io/badge/lifecycle-stabilizing-green)
![CodeSize](https://img.shields.io/github/languages/code-size/oswaldogressani/EpiLPS?color=orange&label=Code%20size&style=plastic)
![UserStars](https://img.shields.io/github/stars/oswaldogressani/EpiLPS?style=social)
![MyTwitter](https://img.shields.io/twitter/follow/OswaldoGressani?style=social)

<img src="man/figures/gplv3-or-later.png" width="10%" style="display: block; margin: auto auto auto 0;" />

<br>

**EpiLPS** <span style="color: green;"> (Gressani et al. 2022)</span> is
an **Epi**demiological modeling tool using
**L**aplacian-**P**-**S**plines. It can be used to estimate the
time-varying reproduction number (the average number of secondary cases
generated by an infected individual) and to smooth the epidemic curve
based on a time series of incidence data and a (discretized) serial
interval distribution. The website associated to the project
<https://epilps.com/> provides a detailed documentation (or vignette) on
how to use the routines.

#### Citation

For the paper explaining the methodology:

Gressani, O., Wallinga, J., Althaus, C. L., Hens, N. and Faes, C.
(2022). EpiLPS: A fast and flexible Bayesian tool for estimation of the
time-varying reproduction number. *PLoS Comput Biol* **18**(10):
e1010618. <https://doi.org/10.1371/journal.pcbi.1010618>

    To cite the EpiLPS package in publications use:

      Gressani, O. (2021). EpiLPS: a fast and flexible Bayesian tool for estimation of the time-varying
      reproduction number. [Computer Software]. https://github.com/oswaldogressani/EpiLPS.

    A BibTeX entry for LaTeX users is

      @Manual{,
        title = {EpiLPS: a fast and flexible Bayesian tool for estimation
        of the time-varying reproduction number. [Computer Software]},
        author = {Oswaldo Gressani},
        year = {2021},
        url = {https://github.com/oswaldogressani/EpiLPS},
      }

#### Package version

This is version 1.1.0 (2023-03-22) - “Reducing cyclomatic complexity”.

#### Acknowledgments

This project is funded by the European Union’s Research and Innovation
Action under the H2020 work programme, EpiPose (grant number 101003688).

#### License

EpiLPS: a fast and flexible Bayesian tool for estimation of the
time-varying reproduction number. Copyright (C) 2021-2023 Oswaldo
Gressani.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along
with this program. If not, see <https://www.gnu.org/licenses/>.
