% Generated by roxygen2 (4.0.1): do not edit by hand
\name{check_bip_degdist}
\alias{check_bip_degdist}
\title{Check Degree Distribution for Bipartite Target Statistics}
\usage{
check_bip_degdist(num.m1, num.m2, deg.dist.m1, deg.dist.m2)
}
\arguments{
\item{num.m1}{number of nodes in mode 1.}

\item{num.m2}{number of nodes in mode 2.}

\item{deg.dist.m1}{vector with fractional degree distribution for mode 1.}

\item{deg.dist.m2}{vector with fractional degree distribution for mode 2.}
}
\description{
Checks for consistency in the implied network statistics
             of a bipartite network in which the mode size and mode-specific
             degree distributions are specified.
}
\details{
This function outputs the number of nodes of degree 0 to m, where m is the
length of a fractional degree distribution vector, given that vector and the
size of the mode. This utility is used to check for balance in implied degree
given that fractional distribution within bipartite network simulations, in
which the degree-constrained counts must be equal across modes.
}
\examples{
# An unbalanced distribution
check_bip_degdist(num.m1 = 500, num.m2 = 500,
                  deg.dist.m1 = c(0.40, 0.55, 0.03, 0.02),
                  deg.dist.m2 = c(0.48, 0.41, 0.08, 0.03))

# A balanced distribution
targets <- check_bip_degdist(num.m1 = 500, num.m2 = 500,
                  deg.dist.m1 = c(0.40, 0.55, 0.04, 0.01),
                  deg.dist.m2 = c(0.48, 0.41, 0.08, 0.03))
targets
}
\seealso{
For a detailed explanation of this function, see the HTML vignette:
\href{http://statnet.org/EpiModel/vignette/NetUtils.html}{EpiModel Network
Utility Functions}.
}
\keyword{netUtils}

