% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.inputs.R
\name{generate_random_params}
\alias{generate_random_params}
\title{Generate Values for Random Parameters}
\usage{
generate_random_params(param, verbose = FALSE)
}
\arguments{
\item{param}{The \code{param} argument received by the \code{netsim}
functions.}

\item{verbose}{Should the function output the generated values
(default = FALSE)?}
}
\value{
A fully instantiated \code{param} list.
}
\description{
This function uses the generative functions in the
             \code{random.params} list to create values for the parameters.
}
\section{\code{random_params}}{

The \code{random_params} argument to the \code{param.net} function must be a
named list of functions that return a values that can be used as the argument
with the same name. In the example below, \code{param_random} is a function
factory provided by EpiModel for \code{act.rate} and \code{tx.halt.part.prob}
we provide bespoke functions.
}

\section{Generator Functions}{

The function used inside \code{random_params} must be 0 argument functions
returning a valid value for the parameter with the same name.
}

\examples{
\dontrun{

# Define random parameter list
my_randoms <- list(
  act.rate = param_random(c(0.25, 0.5, 0.75)),
  tx.prob = function() rbeta(1, 1, 2),
  stratified.test.rate = function() c(
    rnorm(1, 0.05, 0.01),
    rnorm(1, 0.15, 0.03),
    rnorm(1, 0.25, 0.05)
  )
)

# Parameter model with fixed and random parameters
param <- param.net(inf.prob = 0.3, random.params = my_randoms)

# Below, `tx.prob` is set first to 0.3 then assigned a random value using
# the function from `my_randoms`. A warning notifying of this overwrite is
# therefore produced.
param <- param.net(tx.prob = 0.3, random.params = my_randoms)


# Parameters are drawn automatically in netsim by calling the function
# within netsim_loop. Demonstrating draws here but this is not used by
# end user.
paramDraw <- generate_random_params(param, verbose = TRUE)
paramDraw

}

}
