% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.inputs.R
\name{param_random}
\alias{param_random}
\title{Create a Value Sampler for Random Parameters}
\usage{
param_random(values, prob = NULL)
}
\arguments{
\item{values}{a vector of values to sample from.}

\item{prob}{a vector of weights to use during sampling, if \code{NULL},
all values have the same probability of being picked
(default = \code{NULL}).}
}
\value{
one of the values from the \code{values} vector.
}
\description{
This function returns a 0 argument function that can be used as
             a generator function in the \code{random_params} argument of the
             \code{\link{param.net}} function.
}
\examples{
# Define function with equal sampling probability
a <- param_random(1:5)
a()

# Define function with unequal sampling probability
b <- param_random(1:5, prob = c(0.1, 0.1, 0.1, 0.1, 0.6))
b()

}
\seealso{
\code{\link{param.net}} and \code{\link{generate_random_params}}
}
