% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_cuml.R
\name{update_cumulative_edgelist}
\alias{update_cumulative_edgelist}
\title{Update a Cumulative Edgelist of the Specified Network}
\usage{
update_cumulative_edgelist(dat, network, truncate = 0)
}
\arguments{
\item{dat}{Main \code{netsim_dat} object containing a \code{networkDynamic}
object and other initialization information passed from
\code{\link{netsim}}.}

\item{network}{Numerical index of the network for which the cumulative
edgelist will be updated. (May be > 1 for models with
multiple overlapping networks.)}

\item{truncate}{After how many time steps a partnership that is no longer
active should be removed from the output.}
}
\value{
The updated \code{netsim_dat} main list object.
}
\description{
Update a Cumulative Edgelist of the Specified Network
}
\section{Truncation}{

To avoid storing a cumulative edgelist too long, the \code{truncate}
parameter defines a number of steps after which an edge that is no longer
active is truncated out of the cumulative edgelist.
When \code{truncate = Inf}, no edges are ever removed. When
\code{truncate = 0}, only the active edges are kept. You may want this
behavior to keep track of the active edges' start step.
}

