% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{adjust_infection_to_report}
\alias{adjust_infection_to_report}
\title{Adjust from Case Counts by Infection Date to Date of Report}
\usage{
adjust_infection_to_report(
  infections,
  delay_defs,
  reporting_model,
  reporting_effect,
  type = "sample",
  truncate_future = TRUE
)
}
\arguments{
\item{infections}{\code{data.table} containing a \code{date} variable and a numeric \code{cases} variable.}

\item{delay_defs}{A list of single row data.tables that each  defines a delay distribution (model, parameters and maximum delay for each model).
See \code{lognorm_dist_def} for an example of the structure.}

\item{reporting_model}{A function that takes a single numeric vector as an argument and returns a
single numeric vector. Can be used to apply stochastic reporting effects. See the examples for details.}

\item{reporting_effect}{A numeric vector of length 7 that allows the scaling of reported cases
by the day on which they report (1 = Monday, 7 = Sunday). By default no scaling occurs.}

\item{type}{Character string indicating the method to use to transform counts. Supports either "sample"
which approximates sampling or "median" would shift by the median of the distribution.}

\item{truncate_future}{Logical, should cases be truncated if they occur after the first date reported in the data.
Defaults to \code{TRUE}.}
}
\value{
A \code{data.table} containing a \code{date} variable (date of report) and a \code{cases} variable. If \code{return_onset = TRUE} there will be
a third variable \code{reference} which indicates what the date variable refers to.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Maps from cases by date of infection to date of report via date of
onset.
}
\examples{
\donttest{
# define example cases
cases <- data.table::copy(example_confirmed)[, cases := as.integer(confirm)]

# define a single report delay distribution
delay_def <- lognorm_dist_def(
  mean = 5, mean_sd = 1, sd = 3, sd_sd = 1,
  max_value = 30, samples = 1, to_log = TRUE
)

# define a single incubation period
incubation_def <- lognorm_dist_def(
  mean = incubation_periods[1, ]$mean,
  mean_sd = incubation_periods[1, ]$mean_sd,
  sd = incubation_periods[1, ]$sd,
  sd_sd = incubation_periods[1, ]$sd_sd,
  max_value = 30, samples = 1
)

# simple mapping
report <- adjust_infection_to_report(cases, delay_defs = list(incubation_def, delay_def))
print(report)

# mapping with a weekly reporting effect
report_weekly <- adjust_infection_to_report(
  cases,
  delay_defs = list(incubation_def, delay_def),
  reporting_effect = c(1.1, rep(1, 4), 0.95, 0.95)
)
print(report_weekly)

# map using a deterministic median shift for both delays
report_median <- adjust_infection_to_report(cases,
  delay_defs = list(incubation_def, delay_def),
  type = "median"
)
print(report_median)

# map with a weekly reporting effect and stochastic reporting model
report_stochastic <- adjust_infection_to_report(
  cases,
  delay_defs = list(incubation_def, delay_def),
  reporting_effect = c(1.1, rep(1, 4), 0.95, 0.95),
  reporting_model = function(n) {
    out <- suppressWarnings(rnbinom(length(n), as.integer(n), 0.5))
    out <- ifelse(is.na(out), 0, out)
  }
)
print(report_stochastic)
}
}
\author{
Sam Abbott
}
