% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AER_trend_graph.R
\name{plotTS12MAvg}
\alias{plotTS12MAvg}
\title{Time series with 12-month moving average}
\usage{
plotTS12MAvg(data, xvar = "TimeCode", yvar = "N", movAverage = "MAV")
}
\arguments{
\item{data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the time variable to plot on the x-axis
in quotes (default \code{"TimeCode"})}

\item{yvar}{character string, name of the variable to plot on the y-axis in quotes
(default \code{"N"}), number of cases by month over the 5-year period (grey solid line)}

\item{movAverage}{character string, name of the variable to plot in quotes including
the moving average per each time unit (default \code{"MAV"})}
}
\description{
This function draws a line graph describing the trend of the selected disease
over the past 5 years. \cr
The graph includes the trend and number of cases at EU/EEA level, by month,
over the past five years, with:
\itemize{
   \item{\code{yvar}: }{The number of cases by month over the 5-year period (grey solid line)}
   \item{\code{movAverage}: }{The 12-month moving average of the number of cases by month (green solid line)}
}
Expects aggregated data and pre-calculated 12-month moving average.
}
\seealso{
Global function: \code{\link{getTrend}}  \cr
Required Packages: \code{\link{ggplot2}}
}
\keyword{average,}
\keyword{moving}
\keyword{trend}
