% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPie.R
\name{plotPie}
\alias{plotPie}
\title{Pie chart}
\usage{
plotPie(
  .data,
  xvar = "",
  labels = "",
  fill_colors = EcdcColors(col_scale = "qual", n = nrow(.data))
)
}
\arguments{
\item{.data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the numerical variable
to plot in quotes}

\item{labels}{character string, name of the character variable
including the corresponding labels}

\item{fill_colors}{vector of character strings, hexadecimal colours
to use for each labels in the piechart; the vector should contain
the exact number of categories defined in \code{"labels"} variable.
(default to ECDC colors, see
\code{EcdcColors(col_scale = "qual", n = nrow(.data))})}
}
\description{
This function draws a pie chart of the values of variable 'Xvar'
with the labels from the categorical variable 'Labels'. \cr
Expects aggregated data.
}
\examples{
# --- Create dummy data
piechart <- data.frame(Labels = c("Heterosexual females",
                                  "Heterosexual males",
                                  "MSM",
                                  "Unknow"),
                       Values = c(1633,2937,15342,2854))

# --- Plot the dummy data
plotPie(piechart,
         xvar = "Values",
         labels = "Labels")

}
\seealso{
Internal function: \code{\link{EcdcColors}} \cr
Required Packages: \code{\link[ggplot2]{ggplot}}
}
\keyword{pie}
