% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isgr_index.R
\name{desv_clim}
\alias{desv_clim}
\title{Auxiliary function for calculating ISGR}
\usage{
desv_clim(ENV, AAT, PREC)
}
\arguments{
\item{ENV}{Identification of each selection environment (to differentiate if
there is more than one cultivation cycle).}

\item{AAT}{Average air temperature (in degree Celsius) during the cycle in
each environment.}

\item{PREC}{Rainfall (in mm) during the cultivation cycle in each environment}
}
\value{
A dataframe containing the identifier of the selection environment and
the standard deviations for temperature and precipitation.
}
\description{
This function receives a dataframe with temperature and precipitation data
and calculates the standard deviation of these parameters for each environment.
}
\examples{
library(EstimateBreed)
data("desvamb")
head(desvamb)

#Use DPclim for the ISGR function to identify deviations correctly
DPclim <- with(desvamb,desv_clim(ENV,TMED,PREC))
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
