% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Stock.Performers.R
\name{EN_Stock.Performers}
\alias{EN_Stock.Performers}
\title{Retrieve performance data for stocks from various markets on the Euronext exchange.}
\usage{
EN_Stock.Performers(
  direction = "MostActive",
  since,
  stock_choice = "All",
  capitalization = "All",
  belongs_to = "All",
  eligibility = "all",
  icb_sector = ""
)
}
\arguments{
\item{direction}{(character) Direction of the stock performance data. Can be one of 'MostActive', 'Risers' (or 'R' or 'Up') , 'Fallers' (or 'F' or 'Down').}

\item{since}{(character) Duration since when the performance data is requested. Allowed values: "1D" (1 day), "1M" (1 month), "1Y" (1 year), "1Jan" (since January 1st).}

\item{stock_choice}{(character) Choice of the stock market. Allowed values: 'All', 'Amsterdam' (or 'A'), 'Brussels' (or 'B'), 'Dublin' (or 'D'), 'Lisbon' (or 'L'), 'Milan' (or 'M'), 'Paris' (or 'P'), 'Oslo' (or 'O').}

\item{capitalization}{(character) Capitalization filter for stocks. Allowed values: 'All', 'Large Caps' (or 'LC'), 'Mid Caps' (or 'MC'), 'Small Caps' (or 'SC').}

\item{belongs_to}{(character) Ownership filter for stocks. Depends on the chosen \code{stock_choice}. Consult the function documentation for valid values.}

\item{eligibility}{(character) Eligibility criteria for stocks. Depends on the chosen \code{stock_choice}. Consult the function documentation for valid values. Default value: 'all'.}

\item{icb_sector}{(character) ICB sector filter for stocks.}
}
\value{
A dataframe containing performance data for the specified stocks. Columns include: 'Name', 'Symbol', 'Price', 'Change \%', 'Volume', 'Turnover', 'Market Cap (M)'. If no data is available, it returns \code{NULL}.
}
\description{
This function retrieves performance data for stocks from different markets on the Euronext exchange.
}
\examples{
\donttest{
library(httr)
library(httr2)
library(rvest)

# Retrieve performance data for Brussels market
b_perf_data <- EN_Stock.Performers(direction = 'MostActive',
                                    since = "1D",
                                    stock_choice = "Brussels",
                                    capitalization = 'All',
                                    belongs_to = "All",
                                    eligibility = "all",
                                    icb_sector = "")


# Retrieve performance data for Oslo market with Euronext expand filter for fallers
o_perf_data <- EN_Stock.Performers(direction = 'f',
                                    since = "1M",
                                    stock_choice = "Oslo",
                                    capitalization = 'All',
                                    belongs_to = "EuronextExpand",
                                    eligibility = "all",
                                    icb_sector = "")


# Retrieve performance data for Paris market with specific filters
p_perf_data <- EN_Stock.Performers(direction = 'R',
                                   since = "1Jan",
                                   stock_choice = "Paris",
                                   capitalization = 1,
                                   belongs_to = "CACLARGE60",
                                   eligibility = "PEA",
                                   icb_sector = "")


# Retrieve performance data for all markets with specific filters
all_perf_data <- EN_Stock.Performers(direction = 'MostActive',
                                     since = "1D",
                                     stock_choice = "all",
                                     capitalization = 3,
                                     belongs_to = "Euro100",
                                     eligibility = "all",
                                     icb_sector = "")

}

}
\seealso{
Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\author{
Koffi Frederic SESSIE
}
\concept{Data Retrieval}
\concept{Euronext}
