% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildEDModel.R
\name{buildEDModel}
\alias{buildEDModel}
\title{build Event Detection Model}
\usage{
buildEDModel(x, dataPrepators = "ImputeTSInterpolation",
  dataPreparationControl = list(), buildModelAlgo = "ForecastETS",
  buildModelControl = list(), postProcessors = "bedAlgo",
  postProcessorControl = list(), ignoreVarianceWarning = FALSE,
  oldModel = NULL)
}
\arguments{
\item{x}{data.frame containing initial data on which the model will be fitted.
Data should be free of events. The data should not include a timestamp column}

\item{dataPrepators}{string or vector of strings, that defines which preparators to use.
Lists are not accepted. Usage Example: dataPreparators = "ImputeTSInterpolation" results in the usage of
imputeTS::na.interpolation as a data preparator. All possible preparators are listed via:
getSupportedPreparations()
Can also be set to NULL in order to shut off data preparation}

\item{dataPreparationControl}{list, control-list containing all additional parameters that shall be passed
to the dataPreparators.}

\item{buildModelAlgo}{string, model name to be used. All possible preparators
are listed via: getSupportedModels().}

\item{buildModelControl}{list, control-list containing all additional parameters that shall be passed
to the modelling algo.}

\item{postProcessors}{string or vector of strings, that defines which postProcessors to use.
Lists are not accepted. Usage Example: postProcessors = "bedAlgo" results in the usage of
bed as a event postProcessing tool. All possible preparators are listed via:
getSupportedPostProcessors()
Can also be set to NULL in order to shut off data postProcessing}

\item{postProcessorControl}{list, control-list containing all additional parameters that shall be passed
to the postProcessirs.}

\item{ignoreVarianceWarning}{Ignores the continously appearing warning for missing variance in some variable
columns given a smaller windowSize}

\item{oldModel}{If another model was previously fitted it can be passed to the next model fit.
By doing so the eventHistory is preserved}
}
\value{
model, event detection object (edObject) containing all models and configurations that are used
to detect events in given data.
}
\description{
Builds an event detection object (edObject) containing all models and configurations that are used
to detect events in given data.
}
\examples{

## build a simple event detection model with standard configuration
x <- stationBData[1:2000,-1]
buildEDModel(x)

## Set up a more complex event detection model defining some additional configuration
buildEDModel(x, dataPrepators = "ImputeTSMean", buildModelAlgo = "ForecastArima")
}
