% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcApplicationInput.R
\name{ARCApplicationInput}
\alias{ARCApplicationInput}
\title{Abnormal Return Calculation Parameters}
\value{
a ESTParameters R6 object
}
\description{
This R6 class defines the parameters for the Return Event Study. We recommend
to use the \code{set} functionality to setup your Event Study, as we check
input parameters.

For more details see the help vignette:
\code{vignette("parameters_eventstudy", package = "EventStudy")}
}
\section{Methods}{

\describe{
  \item{\code{$new()}}{Constructor for ARCApplicationInput.}
  \item{\code{$setEMail(eMail)}}{Set the e-Mail address for reporting. This 
  functionality is currently not working.}
  \item{\code{$setBenchmarkModel(model = 'mm')}}{Setter for the benchmark
  model.s}
  \item{\code{$setReturnType(returnType)}}{Setter for the return type (log 
  or simple)}
  \item{\code{$setTestStatistics(testStatistics)}}{Setter for the test 
  statistics.}
}
}

\section{Arguments}{

\describe{
 \item{ESTARCParameters}{An \code{ARCApplicationInput} object}
 \item{eMail}{An E-Mail address in \code{String} format}
 \item{model}{A benchmark model in \code{String} format}
 \item{returnType}{A return type in \code{String} format}
 \item{testStatistics}{A \code{String} vector with test statistics.}
}
}

\examples{
\dontrun{
# get files for our S&P500 example; 3 files are written in the current 
# working directory
getSP500ExampleFiles()

# Generate a new parameter object
arcParams <- ARCApplicationInput$new()

# set test statistics
arcParams$setBenchmarkModel("garch")

# Setup API object
apiKey <- "{Your API key}"
estSetup <- EventStudyAPI$new()
estSetup$authentication(apiKey)

# Perform Event Study
estSetup$performEventStudy(estParams = arcParams, 
                           dataFiles = c("request_file" = "01_RequestFile.csv",
                                         "firm_data"    = "02_firmData.csv",
                                         "market_data"  = "03_marketData.csv"))

# Download task results and save them in the actiual working directory
estSetup$getTaskResults()
}

}
\section{Super classes}{
\code{\link[EventStudy:ApplicationInputInterface]{EventStudy::ApplicationInputInterface}} -> \code{\link[EventStudy:EventStudyApplicationInput]{EventStudy::EventStudyApplicationInput}} -> \code{ARCApplicationInput}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{task}}{Task description}

\item{\code{key}}{Key}

\item{\code{benchmark_model}}{Benchmark model}

\item{\code{return_type}}{Return type}

\item{\code{non_trading_days}}{How to handle non-trading days}

\item{\code{test_statistics}}{Test statistics}

\item{\code{request_file}}{Request file}

\item{\code{firm_data}}{Firm data}

\item{\code{market_data}}{Market data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ARCApplicationInput-setEMail}{\code{ARCApplicationInput$setEMail()}}
\item \href{#method-ARCApplicationInput-setBenchmarkModel}{\code{ARCApplicationInput$setBenchmarkModel()}}
\item \href{#method-ARCApplicationInput-setReturnType}{\code{ARCApplicationInput$setReturnType()}}
\item \href{#method-ARCApplicationInput-setNonTradingDays}{\code{ARCApplicationInput$setNonTradingDays()}}
\item \href{#method-ARCApplicationInput-setTestStatistics}{\code{ARCApplicationInput$setTestStatistics()}}
\item \href{#method-ARCApplicationInput-setDataFiles}{\code{ARCApplicationInput$setDataFiles()}}
\item \href{#method-ARCApplicationInput-clone}{\code{ARCApplicationInput$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="serialize"><a href='../../EventStudy/html/ApplicationInputInterface.html#method-ApplicationInputInterface-serialize'><code>EventStudy::ApplicationInputInterface$serialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="serializeToJson"><a href='../../EventStudy/html/ApplicationInputInterface.html#method-ApplicationInputInterface-serializeToJson'><code>EventStudy::ApplicationInputInterface$serializeToJson()</code></a></span></li>
<li><span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="setNamedList"><a href='../../EventStudy/html/ApplicationInputInterface.html#method-ApplicationInputInterface-setNamedList'><code>EventStudy::ApplicationInputInterface$setNamedList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="EventStudy" data-topic="ApplicationInputInterface" data-id="setResultFileType"><a href='../../EventStudy/html/ApplicationInputInterface.html#method-ApplicationInputInterface-setResultFileType'><code>EventStudy::ApplicationInputInterface$setResultFileType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="EventStudy" data-topic="EventStudyApplicationInput" data-id="setup"><a href='../../EventStudy/html/EventStudyApplicationInput.html#method-EventStudyApplicationInput-setup'><code>EventStudy::EventStudyApplicationInput$setup()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARCApplicationInput-setEMail"></a>}}
\if{latex}{\out{\hypertarget{method-ARCApplicationInput-setEMail}{}}}
\subsection{Method \code{setEMail()}}{
set email
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARCApplicationInput$setEMail(eMail)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{eMail}}{Your E-mail address}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARCApplicationInput-setBenchmarkModel"></a>}}
\if{latex}{\out{\hypertarget{method-ARCApplicationInput-setBenchmarkModel}{}}}
\subsection{Method \code{setBenchmarkModel()}}{
set benchmark model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARCApplicationInput$setBenchmarkModel(model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{benchmark model}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARCApplicationInput-setReturnType"></a>}}
\if{latex}{\out{\hypertarget{method-ARCApplicationInput-setReturnType}{}}}
\subsection{Method \code{setReturnType()}}{
Set return type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARCApplicationInput$setReturnType(returnType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{returnType}}{return type}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARCApplicationInput-setNonTradingDays"></a>}}
\if{latex}{\out{\hypertarget{method-ARCApplicationInput-setNonTradingDays}{}}}
\subsection{Method \code{setNonTradingDays()}}{
Set non trading days
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARCApplicationInput$setNonTradingDays(nonTradingDays = "later")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nonTradingDays}}{how to handle non traing days}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARCApplicationInput-setTestStatistics"></a>}}
\if{latex}{\out{\hypertarget{method-ARCApplicationInput-setTestStatistics}{}}}
\subsection{Method \code{setTestStatistics()}}{
Set test statistics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARCApplicationInput$setTestStatistics(testStatistics = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{testStatistics}}{Test statistic}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARCApplicationInput-setDataFiles"></a>}}
\if{latex}{\out{\hypertarget{method-ARCApplicationInput-setDataFiles}{}}}
\subsection{Method \code{setDataFiles()}}{
Set reques, firm, and market data file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARCApplicationInput$setDataFiles(
  dataFiles = c(request_file = "01_RequestFile.csv", firm_data = "02_firmData.csv",
    market_data = "03_MarketData.csv")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataFiles}}{Named vector of data files.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARCApplicationInput-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ARCApplicationInput-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARCApplicationInput$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
