% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExPanD.R
\name{ExPanD}
\alias{ExPanD}
\title{Explore Panel Data (ExPanD)}
\usage{
ExPanD(df = NULL, cs_id = NULL, ts_id = NULL, df_def = NULL,
  var_def = NULL, config_list = NULL,
  title = "ExPanD - Explore panel data interactively", abstract = NULL,
  df_name = deparse(substitute(df)), long_def = TRUE, factor_cutoff = 10L,
  components = c(bar_chart = TRUE, missing_values = TRUE, descriptive_table =
  TRUE, by_group_bar_graph = TRUE, histogram = TRUE, ext_obs = TRUE, trend_graph
  = TRUE, quantile_trend_graph = TRUE, corrplot = TRUE, scatter_plot = TRUE,
  regression = TRUE), store_encrypted = FALSE,
  key_phrase = "What a wonderful key", debug = FALSE, ...)
}
\arguments{
\item{df}{A data frame or a list of data frames containing the panel data that
you want to explore. If NULL, ExPanD will start up with a file upload
dialog.}

\item{cs_id}{A character vector containing the names of the variables that
identify the cross-section in your data.
Can only be NULL if \code{df_def} is provided instead.}

\item{ts_id}{A character scalar identifying the name of
the variable that identifies the time series in your data. The according
variable needs to be coercible to an ordered vector.
Can only be NULL if \code{df_def} is provided instead.}

\item{df_def}{An optional dataframe (or a list of dataframes) containing
variable names, definitions and types. If NULL (the default) ExPanD
uses \code{cs_id} and \code{ts_id} to identify the panel structure and
determines the variable types (factor, numeric, logical) based on the
classes of the data. See the details section for further information.}

\item{var_def}{If you specify here a dataframe containing variable names and
variable definitions, ExPanD will use these on the provided sample(s) to
create the analysis sample. In that case, the user gets the opportunity to
add additional variables in the app. See the details section
for the structure of the \code{var_def} dataframe. If NULL (default)
the sample(s) provided by \code{df} will be used as analysis sample(s) directly.}

\item{config_list}{a list containing the startup configuration for ExPanD to
display. Take a look at \code{data(ExPanD_config_russell_3000)} for the
format. The easiest way to generate a config list is to customize the
display within the app and then save the configuration locally.}

\item{title}{the title to display in the shiny web app.}

\item{abstract}{An introductory text to display in the shiny web app. Needs
to be formatted as clean HTML.}

\item{df_name}{A character string or a vector of character strings
characterizing the dataframe(s) provided in \code{df} (will be used in the
selection menu of the app)}

\item{long_def}{If you set this to TRUE (default) and are providing a
\code{var_def} then ExPanD will add the definitions of the used variables
of the underlying dataframe to the definitions provided for the analysis
sample to make these more informative to the user.
If set to FALSE only the variable definitions provided in the
\code{var_def} sample will be provided to the user.}

\item{factor_cutoff}{ExPanD treats factors different from numerical variables.
Factors are available for sub-sampling data and for certain plots.
Each variable classified as such will be treated as a factor. In addition,
ExPanD classifies all logical values and all numerical values with less or
equal than \code{factor_cutoff} unique values as a factor.}

\item{components}{A logical vector indicating which reports you want
ExPanD to generate. If specified, the vector does not have to be named but needs
to be of correct length.}

\item{store_encrypted}{Do you want the user-side saved config files to be
encrypted? A security measure to avoid that users can inject arbitrary code
in the config list. Probably a good idea when you are hosting sensitive data
on a publicly available server.}

\item{key_phrase}{The key phrase to use for encryption.
Change this from the default if you want to encrypt the config files.}

\item{debug}{Do you want ExPanD to echo some debug timing information to the
console/log file and to store some diagnostics to the global environment?
Probably not.}

\item{...}{Additional parameters that are passed on to
\code{\link[shiny]{runApp}}.}
}
\description{
A shiny based web app that uses ExPanDaR functionality for
interactive panel data exploration
}
\details{
If you start ExPanD without any options, it will start with an upload
dialog so that the the user (e.g., you) can upload a data file
for analysis. Supported formats are as provided
by the \code{rio} package.

If you provide variable definitions in \code{df_def} and/or \code{var_def},
ExPanD displays these as tooltips in the descriptive table of the
ExPanD app.

When you provide more than one data frame in \code{df}, make sure that all have
the same variables and variable types defined. If not, ExPanD will throw
an error. When you provide only one \code{df_def} for multiple data frames,
\code{df_def} will be recycled.

When you provide \code{var_def}, ExPanD starts up in the "advanced mode". The
advanced mode uses (a) base sample(s) (the one(s) you provide via \code{df})
and the variable definitions in \code{var_def} to generate an analysis
sample based on the active base sample. In the advanced mode, the app user
can generate additional variables from within the app.

A \code{df_def} or \code{var_def} dataframe can contain the following
variables
\describe{
\item{"var_name"}{Required: The names of the variables
that are provided by the base sample
or are to be calculated for the analysis sample}
\item{"var_def"}{Required: For a \code{var_def} data frame,
the code that is passed to the data frame
(grouped by cross-sectional units) in calls to
\code{\link[dplyr]{mutate}} as right hand side
to calculate the respective variable.
For a \code{data_def} data frame, a string
describing the nature of the variable.}
\item{"type"}{Required: One of the strings "cs_id", "ts_id", "factor",
"logical" or "numeric", indicating the type of the variable. Please note that
at least one variable has to be assigned as a cross-sectional identifier
("cs_id") and exactly one variable that is coercible into an ordered factor
has to be assigned as the time-series identifier ("ts_id").}
\item{"can_be_na"}{Optional: If included,
then all variables with this value set to FALSE are required to be non
missing in the data set. This reduces the number of observations. If missing,
it defaults to being TRUE for all variables other than cs_id and ts_id.} }
}
\examples{
\dontrun{
  ExPanD()
  # Use this if you want to read very large files via the file dialog
  options(shiny.maxRequestSize = 1024^3)
  ExPanD()

  data(russell_3000)
  ExPanD(russell_3000, c("coid", "coname"), "period")
  ExPanD(russell_3000, df_def = russell_3000_data_def)
  ExPanD(russell_3000, df_def = russell_3000_data_def,
    components = c(T, F, T, F, F, F, F, F, F, T, T))
  data(ExPanD_config_russell_3000)
  ExPanD(df = russell_3000, df_def = russell_3000_data_def,
    config_list = ExPanD_config_russell_3000)
  exploratory_sample <- sample(nrow(russell_3000), round(0.5*nrow(russell_3000)))
  test_sample <- setdiff(1:nrow(russell_3000), exploratory_sample)
  ExPanD(df = list(russell_3000[exploratory_sample, ], russell_3000[test_sample, ]),
    df_def = russell_3000_data_def,
    df_name = c("Exploratory sample", "Test sample"))
  ExPanD(worldbank, df_def = worldbank_data_def, var_def = worldbank_var_def,
    config_list = ExPanD_config_worldbank)}
}
