% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_eigen.R
\name{recombination_eigen}
\alias{recombination_eigen}
\title{/eigen recombination for DE}
\usage{
recombination_eigen(X, M, recpars)
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/eigen" (eigenvector-based) recombination for the ExpDE 
framework
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_eigen()} understands the following fields 
in \code{recpars}:
\itemize{
   \item \code{othername}: name of the recombination operator to be applied 
                           after the projection in the eigenvector basis
   \item \code{...} :  parameters required (or optional) to the operator 
                       defined by \code{recpars$othername}
}
}

\section{References}{

Shu-Mei Guo e Chin-Chang Yang, "Enhancing differential evolution utilizing 
eigenvector-based crossover operator", IEEE Transactions on Evolutionary 
Computation 19(1):31-49, 2015.
}

