% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_bands.R
\name{join_bands}
\alias{join_bands}
\title{Function to compare image sizes  (Funcao para comparar os tamanhos das imagens).}
\usage{
join_bands(imgs=NULL,filesnames=NULL,path = NULL)
}
\arguments{
\item{imgs}{:List object containing the images  (Objeto do tipo lista contendo as imagens).}

\item{filesnames}{:Images names (Nomes das imagens).}

\item{path}{:Path files  (Endereco das pastas).}
}
\value{
Return images size (Retorna o tamanho das imagens).
}
\description{
This function compares the size of images  (Esta funcao compara o tamanho das imagens).
}
\examples{
###############################################
#Carregando imagens de exemplo
im1=read_image(example_image(2),plot=TRUE)
r=gray_scale(im = im1,method = "r",normalize=FALSE)
g=gray_scale(im = im1,method = "g",normalize=FALSE)
b=gray_scale(im = im1,method = "b",normalize=FALSE)

im2=join_bands(imgs = list(r,g,b))
plot_image(im2)

\dontrun{
# Not run: Depende do upload de imagens do github
#(It depends uploading images from github).



#########################################################
#########################################################
#' #' ########################################################
###' Abrindo o endereco de bandas de imagens de satelite
########################################################
end1=example_image(14) #Banda de azul
end2=example_image(15) #Banda de verde
end3=example_image(16) #Banda de vermelho
end4=example_image(17) #Banda de IR
end5=example_image(18) #Banda de SWIR

########################################################
###' Abrindo bandas de imagens de satelite
########################################################
B1=read_image(end1,plot=TRUE)
B2=read_image(end2,plot=TRUE)
B3=read_image(end3,plot=TRUE)
B4=read_image(end4,plot=TRUE)
B5=read_image(end5,plot=TRUE)

########################################################
###' Juntando as bandas em uma imagem
########################################################
im=join_bands(imgs = list(B1,B2,B3,B4,B5))
tif_info(im)
plot_image(im,r=3,g=2,b=1,rasterRGB=TRUE)
}
}
\seealso{
\code{\link{info_image}} , \code{\link{read_image}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
