% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VapPres.R
\name{PsyCon}
\alias{PsyCon}
\title{Psychrometric Constant (gamma)}
\usage{
PsyCon(P, lambda = 2.45, c_p = 1.013 * 10^(-3), eps = 0.622)
}
\arguments{
\item{P}{A numeric scalar that denotes the atmospheric pressure [kPa].}

\item{lambda}{A numeric scalar that denotes the latent heat of vaporization, 2.45 [MJ/kg].}

\item{c_p}{A numeric scalar that denotes the specific heat at constant pressure, 1.013*10^(-3) [MJ/(kg*C).}

\item{eps}{A numeric scalar that denotes the ratio molecular weight of water vapour/dry air = 0.622.}
}
\value{
The function returns the value of the psychrometric constant [kPa/C] as a numeric scalar.
}
\description{
\code{PsyCon} returns the value of psychrometric constant.
}
\details{
This is a function to calculate the psychrometric constant [kPa/C].
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
PsyCon(P = 81.8)

}
\seealso{
\code{\link{AtmPres}}.
}
