% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbline.R
\name{nbline}
\alias{nbline}
\title{Number & Brightness (Single Image)}
\usage{
nbline(img, plot = TRUE)
}
\arguments{
\item{img}{The image to analyze.}

\item{plot}{by default True. This parameter allow to print the visual comparision of the Brightness and Number.}
}
\value{
Brightness Number   A list containing two vectors, the Brightness and the Number of the image.
}
\description{
Performs the Number and Brightness Analysis (N&B) of a single image.
}
\details{
The N&B method provides molecular concentration and brightness for each pixel of a single image.
The average particle number and brightness are calculated directly from
the mean value <k> and variance (sigma^2) of the fluorescence intensity data (image) for a given pixel as follows: 
N = (<k>^2)/(sigma^2)
and
B = (sigma^2)/<k>
Leaving the plot parameter as True, the function will plot the two vectos in the same plot for a visual comparison, in addition to returning the two vectors.
}
\examples{

dmv2 <- data.matrix(v2DataSet)
nb <- nbline(dmv2, plot = FALSE)
oldpar <- par(no.readonly = TRUE)
par(mar = c(5, 5, 3, 5))
plot(nb$Brightness, type = 'l', col = "blue", ylab = "Brightness (Blue)", xlab = "Pixel")
par(new=TRUE)
plot(nb$Number, type = 'l', col = "red", xaxt = 'n', yaxt = 'n', ylab ="", xlab = "")
axis(4)
mtext("Number (Red)", side = 4, line = 2)
par(oldpar)
}
\seealso{
\code{\link{var}, \link{mean}}
}
\author{
Raul Pinto Camara.
}
