% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binMatrix.R
\name{binMatrix}
\alias{binMatrix}
\title{Binned representation of a matrix}
\usage{
binMatrix(f, lineTime, nIntervals, columns, mode = "mean", plot = TRUE)
}
\arguments{
\item{f}{A vector or a matrix}

\item{lineTime}{Line (row) acquisition rate (in seconds)}

\item{nIntervals}{Number of intervals into which the all columns will be grouped}

\item{columns}{Number of columns of the resulting binned matrix}

\item{mode}{Set to "mean" (default) or "sum" to average or sum all the points in every interval, respectively}

\item{plot}{Boolean, set to TRUE (default) to plot the result}
}
\value{
A matrix of 'nIntervals' rows
}
\description{
Groups each column in a matrix into several bins of a given length for better (and faster) data plotting
}
\details{
This function groups all the points in each column of the matrix 'f' into 'nIntervals' bins of length = length(f)/nIntervals.
Then, averages or sums all of the points in each bin and plots the result.
If 'f' is a vector, 'columns' is used to build the resulting matrix.
If 'f' is a matrix, then 'columns' takes the value of the number of columns in 'f'.
}
\examples{
\donttest{
### Please navigate to
### (https://github.com/FCSlib/FCSlib/tree/master/Sample\%20Data)
### to find this sample data

# Automatic plot
x <- read.table("Pax.dat")
x <- binMatrix(x[,1], lineTime =  1e-3, nIntervals =  500,
               columns = 64, mode = "mean", plot = T)

# Manual plot (useful for adding custom labels)
x <- read.table("Pax.dat")
x <- binMatrix(x[,1], lineTime =  1e-3, nIntervals =  500,
               columns = 64, mode = "mean", plot = F)
image.plot(x)
}
}
\seealso{
\code{\link{binTimeSeries}}
}
\author{
Alejandro Linares
}
