% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFForest.R
\name{FFForest}
\alias{FFForest}
\title{Creates a forest of fast and frugal decision trees}
\usage{
FFForest(formula = NULL, data = NULL, data.test = NULL, max.levels = 5,
  ntree = 10, train.p = 0.5, algorithm = "ifan", goal = "wacc",
  goal.chase = "wacc", sens.w = 0.5, quiet = TRUE, cpus = 1,
  do.comp = FALSE, do.lr = TRUE, do.cart = TRUE, do.rf = TRUE,
  do.svm = TRUE, rank.method = NULL, hr.weight = NULL)
}
\arguments{
\item{formula}{formula. A formula specifying a binary criterion as a function of multiple variables}

\item{data}{dataframe. A dataframe containing variables in formula}

\item{data.test}{dataframe. An optional dataframe of test data}

\item{max.levels}{integer. Maximum number of levels considered for the trees.}

\item{ntree}{integer. Number of trees to create.}

\item{train.p}{numeric. What percentage of the data should be used to fit each tree? Smaller values will result in more diverse trees.}

\item{algorithm}{string. The algorith uses to create FFTs. See arguments in \code{FFTrees()}}

\item{goal}{character. A string indicating the statistic to maximize when selecting final trees: "acc" = overall accuracy, "bacc" = balanced accuracy, "d" = d-prime}

\item{goal.chase}{character. A string indicating the statistic to maximize when constructing trees: "acc" = overall accuracy, "wacc" = weighted accuracy, "bacc" = balanced accuracy}

\item{sens.w}{numeric. How much weight to give to maximizing hits versus minimizing false alarms (between 0 and 1)}

\item{quiet}{logical. Should progress reports be printed?}

\item{cpus}{integer. Number of cpus to use. Any value larger than 1 will initiate parallel calculations in snowfall.}

\item{do.comp, do.lr, do.cart, do.rf, do.svm}{logical. See arguments in \code{FFTrees()}}

\item{rank.method, hr.weight}{depricated arguments}
}
\value{
An object of class \code{FFForest} with the following elements...
}
\description{
This function is currently in development. The idea is to generate a random forest of fast and frugal trees from many splits of the training dataset.
}
\examples{

\dontrun{
cancer.fff <- FFForest(formula = diagnosis ~.,
                       data = breastcancer,
                       ntree = 10,
                       train.p = .5,
                       cpus = 1)
}


}
