% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFFTrees_function.R
\name{print.FFTrees}
\alias{print.FFTrees}
\title{Print basic information of fast-and-frugal trees (FFTs)}
\usage{
\method{print}{FFTrees}(x = NULL, tree = 1, data = "train", ...)
}
\arguments{
\item{x}{An \code{FFTrees} object created by \code{\link{FFTrees}}.}

\item{tree}{The tree to be printed (as an integer, only valid when the corresponding tree argument is non-empty).
Default: \code{tree = 1}.
To print the best training or best test tree with respect to the \code{goal} specified during FFT construction,
use \code{"best.train"} or \code{"best.test"}, respectively.}

\item{data}{The data in \code{x} to be printed (as a string);
must be either \code{'train'} (for fitting performance) or \code{'test'} (for prediction performance).
By default, \code{data = 'train'} (as \code{x} may not contain test data).}

\item{...}{additional arguments passed to \code{print}.}
}
\value{
Prints summary information about an FFT to the console.
}
\description{
\code{print.FFTrees} prints basic information on FFTs for an \code{FFTrees} object \code{x}.

As \code{x} may not contain test data, \code{print.FFTrees} by default prints the performance characteristics for training data (i.e., fitting), rather than for test data (i.e., for prediction).
When test data is available, specify \code{data = "test"} to print prediction performance.
}
\seealso{
\code{\link{plot.FFTrees}} for plotting FFTs;
\code{\link{summary.FFTrees}} for summarizing FFTs;
\code{\link{inwords}} for obtaining a verbal description of FFTs;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.
}
