% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datExportData.R
\name{datExportData}
\alias{datExportData}
\title{Spatial - Exports a data frame object.}
\usage{
datExportData(
  dfobj,
  create_dsn = FALSE,
  index.unique = NULL,
  index = NULL,
  savedata_opts = savedata_options()
)
}
\arguments{
\item{dfobj}{Data.frame class R object. Data frame object to export.}

\item{create_dsn}{Boolean.}

\item{index.unique}{String. Name of variable(s) in dfobj to make unique
index.}

\item{index}{String. Name of variable(s) in dfobj to make (non-unique)
index.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options.}
}
\value{
An sf spatial object is written to the out_dsn.
}
\description{
Exports a data frame object to a specified output.
}
\details{
Wrapper for sf::st_write function.
}
\note{
If out_fmt='shp':\cr The ESRI shapefile driver truncates variable
names to 10 characters or less.  Variable names are changed before export
using an internal function (trunc10shp). Name changes are output to the
outfolder, 'outshpnm'_newnames.csv.

If sf object has more than 1 record, it cannot be exported to a shapefile.
}
\author{
Tracey S. Frescino
}
\keyword{data}
