% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitUtil.R
\name{kCounts}
\alias{kCounts}
\alias{kPvalue}
\alias{purl2}
\alias{reproInfo}
\alias{kPvalue}
\alias{purl2}
\alias{reproInfo}
\title{Specific utilities for use in a knitr document.}
\usage{
kCounts(value, capitalize = FALSE)

kPvalue(value, digits = 4, include.p = TRUE, latex = TRUE)

purl2(file, out.dir = NULL, newname = NULL, topnotes = NULL,
  moreItems = NULL, blanks = c("extra", "all", "none"), delHeader = NULL,
  timestamp = TRUE, ...)

reproInfo(out = c("r", "markdown", "latex"), rqrdPkgs = NULL,
  elapsed = NULL, width = 0.95 * getOption("width"), addTOC = TRUE,
  newpage = FALSE, links = NULL, closeGraphics = TRUE, ind = 1)
}
\arguments{
\item{value}{A single numeric count or p-value.}

\item{capitalize}{A logical that indicates if the returned words should be capitalized or not (the default).}

\item{digits}{Number of decimal places to round the values to.}

\item{include.p}{A logical that indicates whether the result should be a character string with \dQuote{p=} appended to the numerical result.}

\item{latex}{A logical that indicates whether the resultant p-value string should be contained within dollar signs to form a latex formula.}

\item{file}{A string that contains the root name of the .RNW file.  This will also be the name of the resultant purled file with .R appended.}

\item{out.dir}{A string that indicates the directory structure in which the purled file should be located.  This should not have a forward slash at the end.}

\item{newname}{A string for the output filename (without the extension) from \code{purl2}.}

\item{topnotes}{A character vector of lines to be added to the top of the output file.  Each value in the vector will be placed on a single line at the top of the output file.}

\item{moreItems}{A string that contains additional words that when found in the purled file will result in the entire line with those words to be deleted.}

\item{blanks}{A string that indicates if blank lines should be removed.  If \code{blanks="all"} then all blank lines will be removed.  If \code{blanks="extra"} then only \dQuote{extra} blanks lines will be removed (i.e., one blank line will be left where there was originally more than one blank line).}

\item{delHeader}{A single character that denotes the top and bottom of a block of lines that should be deleted from the script created by \code{purl2}.}

\item{timestamp}{A logical that indicates whether a timestamp comment should be appended to the bottom of the script created by \code{purl2}.}

\item{\dots}{Additional arguments for the original \code{purl}.}

\item{out}{A string that indicates the type of output from \code{reproInfo} -- Markdown, LaTeX, or simple R code.}

\item{rqrdPkgs}{A string vector that contains packages that are required for the vignette and for which all dependencies should be found.}

\item{elapsed}{A numeric, usually from \code{proc.time}, that is the time required to run the vignette.  If \code{NULL} then this output will not be used.  See the note below.}

\item{width}{A numeric that indicates the width to use for wrapping the reproducibility information when \code{out="r"}.}

\item{addTOC}{A logical that indicates whether or not a table of contents entry for the reproducibility section should be added to the LaTeX output.  Used only if \R{out="latex"}}

\item{newpage}{A logical that indicates whether or not the reproducibility information should begin on a new page.  Used only if \R{out="latex"}}

\item{links}{A named character vector that will add a links bullet to the reproducibility information.  The names will be shown and the values are the links.  Used only if \R{out="markdown}.}

\item{closeGraphics}{A logical that indicates whether the graphics device should be closed or not.}

\item{ind}{An integer that indicates the CRAN mirror to use. Defaults to 1.}
}
\value{
\itemize{
   \item \code{kCounts} returns a numeric value if the count is less than zero or greater than ten and returns a character string of the number \sQuote{name}.  See the examples.
   \item \code{kPvalue} returns a character string of the supplied p-value rounded to the requested number of digits or a character string that indicates what the p-value is less than the value with a \sQuote{5} in the \code{digits}+1 place.  See the examples. 
   \item \code{purl2} is a modification of \code{\link[knitr]{purl}} from \pkg{knitr} that creates a file with the same name as \code{file} but with lines removed that contain certain words (those found in \code{ItemsToRemove} and \code{moreItems}). 
   \item \code{reproInfo} returns Markdown, LaTeX, or R code that prints \dQuote{reproducibility information} at the bottom of the knitted document.
 }
}
\description{
Specific utilities for pretty printing various items in a knitr document.
}
\details{
\itemize{
   \item \code{kCounts} is used to convert numeric numbers to \sQuote{word} numbers in a sentence.
   \item \code{kPvalue} is used to print \sQuote{pretty} p-values. 
   \item \code{purl2} is used to create a modified (see below) Stangled or purled script.
   \item \code{reproInfo} is used to print \sQuote{reproducibility information} for the document.
 }
}
\note{
In \code{reproInfo}, \code{elapsed} can be used to print the time it took to process the document by sending the elapsed time for processing to this argument.  The simplest way to get an approximate elapsed time is to put  \code{st <- proc.time()} very early (first line?) in your knitr code, put \code{et <- proc.time()-st} very late in your knitr code (i.e., just prior to \code{reproInfo}), and then used \code{elapsed=et["user.self"]+et["sys.self"]} in \code{reproInfo}.
}
\examples{
kCounts(7)
kCounts(17)
kCounts(0)
kCounts(-6)
kCounts(3,capitalize=TRUE)

kPvalue(0.123456789)
kPvalue(0.000123456)
kPvalue(0.000012345)
kPvalue(0.000012345,include.p=FALSE)
kPvalue(0.000012345,include.p=FALSE,latex=FALSE)

}
\seealso{
See \code{\link{formatC}} for functionality similar to \code{kPvalue}.  See \code{\link[knitr]{purl}} and \code{\link[knitr]{knit}} in \pkg{knitr} for functionality similar to \code{purl2}.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{manip}
