context("Confidence Interval functions MESSAGES")
test_that("binCI() messages",{
  expect_error(binCI(-1,10),"must be non-negative")
  expect_error(binCI(1,-10),"must be non-negative")
  expect_error(binCI(11,10),"must not be greater than")
  expect_error(binCI("a",10),"must be whole numbers")
  expect_error(binCI(1,"a"),"must be whole numbers")
  expect_error(binCI(c(-1,2),10),"must be non-negative")
  expect_error(binCI(1,c(-1,10)),"must be non-negative")
  expect_error(binCI(1.1,10),"must be whole numbers")
  expect_error(binCI(1,10.1),"must be whole numbers")
  expect_error(binCI(c(1,1.1),10),"must be whole numbers")
  expect_error(binCI(1,c(9.1,10)),"must be whole numbers")
  expect_error(binCI(c(1,10),5),"must not be greater than")
  expect_error(binCI(c(1,10),c(5,9)),"must not be greater than")
  expect_error(binCI(6,c(5,9)),"must not be greater than")
  expect_error(binCI(6,10,type="derek"),"should be one of")
  expect_error(binCI(6,10,conf.level=0),"must be between 0 and 1")
  expect_error(binCI(6,10,conf.level=1),"must be between 0 and 1")
  expect_warning(binCI(6:9,10),"Can't use multiple 'type's with multiple 'x's")
  expect_error(binCI(data.frame(d=6:9),10),"'x' must be a single or vector")
  expect_error(binCI(2,data.frame(d=6:9)),"'n' must be a single or vector")
})

test_that("hyperCI() messages",{
  expect_error(hyperCI(-1,10,5),"must all be non-negative")
  expect_error(hyperCI(1,-10,5),"must all be non-negative")
  expect_error(hyperCI(1,10,-5),"must all be non-negative")
  expect_error(hyperCI(1,10,5),"'m' must be less than 'M'")
  expect_error(hyperCI(15,5,10),"'m' must be less than 'n'")
  expect_error(hyperCI("a",10,5),"must all be whole numbers")
  expect_error(hyperCI(15,"a",5),"must all be whole numbers")
  expect_error(hyperCI(15,10,"a"),"must all be whole numbers")
  expect_error(hyperCI(20.1,10,5),"must be a whole number")
  expect_error(hyperCI(15,10.1,5),"must be a whole number")
  expect_error(hyperCI(15,10,5.1),"must be a whole number")
  expect_error(hyperCI(c(15,15),10,5),"be a single value")
  expect_error(hyperCI(15,c(10,10),5),"be a single value")
  expect_error(hyperCI(15,10,c(5,5)),"be a single value")
  expect_error(hyperCI(c(15,15),c(10,10),c(5,5)),"be a single value")
  expect_error(hyperCI(15,10,5,conf.level=0),"must be between 0 and 1")
  expect_error(hyperCI(15,10,5,conf.level=1),"must be between 0 and 1")
})

test_that("poiCI() messages",{
  expect_error(poiCI(6,type="derek"),"should be one of")
  expect_error(poiCI(-1),"must be non-negative")
  expect_error(poiCI(c(-1,1:3)),"must be non-negative")
  expect_error(poiCI("a"),"must be a whole number")
  expect_error(poiCI(1.1),"must be a whole number")
  expect_error(poiCI(6,conf.level=0),"must be between 0 and 1")
  expect_error(poiCI(6,conf.level=1),"must be between 0 and 1")
  expect_warning(poiCI(6:9),"Can't use multiple 'type's with multiple 'x's")
  expect_error(poiCI(data.frame(d=6:9)),"'x' must be a single or vector")
})
